% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{results}
\alias{results}
\title{Pulling out result}
\usage{
results(object, name, contrast, indepfilter = TRUE, alpha = 0.1,
  pAdjustMethod = "BH", parallel = FALSE, BPPARAM = bpparam(), ...)
}
\arguments{
\item{object}{a NBAMSeqDataSet object returned by \code{\link{NBAMSeq}}}

\item{name}{the name of nonlinear variable or continuous linear variable}

\item{contrast}{a character of length 3. 1st element: name of factor
variable; 2nd element: name of numerator level; 3rd element: name of
denominator level. contrast = c("group", "treatment", "control") means
comparing treatment vs control for group variable.}

\item{indepfilter}{either TRUE or FALSE indicating whether independent
filtering should be performed. Default is TRUE.}

\item{alpha}{significant threhold for declaring genes as differentially
expressed. Default is 0.1.}

\item{pAdjustMethod}{pvalue adjustment method. Default is "BH". See
\code{\link[stats]{p.adjust}} for details.}

\item{parallel}{either TRUE or FALSE indicating whether parallel should be
used. Default is FALSE.}

\item{BPPARAM}{an argument provided to \code{\link{bplapply}}. See
\code{\link[BiocParallel]{register}} for details.}

\item{...}{additional arguments provided to \code{pvalueAdjustment} function
in DESeq2. See \code{\link[DESeq2]{results}} for details.}
}
\value{
a DataFrame which contains the result
}
\description{
This function pulls out result from NBAMSeqDataSet object
returned by \code{\link{NBAMSeq}}
}
\examples{
gsd = makeExample(n = 3, m = 10)
gsd = NBAMSeq(gsd)
res = results(gsd, name = "pheno")
}
\references{
Love, M.I., Huber, W., Anders, S. (2014) Moderated estimation of
fold change and dispersion for RNA-seq data with DESeq2. Genome Biology,
15:550. \url{https://doi.org/10.1186/s13059-014-0550-8}
}
