% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSig.R
\name{plotSig}
\alias{plotSig}
\title{Plot signals with ideograms}
\usage{
plotSig(ideo, grList, mcolName, ...)
}
\arguments{
\item{ideo}{Output of \link[trackViewer]{loadIdeogram}.}

\item{grList}{A \link[GenomicRanges:GRangesList-class]{GRangesList} of data to plot.}

\item{mcolName}{Column name of metadata of GRangesList for plotting.}

\item{...}{Parameters to pass to \link[trackViewer]{ideogramPlot}}
}
\value{
Invisible argument list for \link[trackViewer]{ideogramPlot}.
}
\description{
Plot signals with ideograms for \link[GenomicRanges:GRangesList-class]{GRangesList}.
}
\examples{

library(trackViewer)
#ideo <- loadIdeogram("mm10")
ideo <- readRDS(system.file("extdata", "ideo.mm10.rds",
                             package = "NADfinder"))
gr1 <- gr2 <- ideo
mcols(gr1) <- DataFrame(score=runif(length(gr1)))
mcols(gr2) <- DataFrame(score=runif(length(gr2)))
grList <- GRangesList(gr1, gr2)
plotSig(ideo, grList, mcolName="score", layout=list("chr1"))


}
