% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_sumstats.R
\name{list_sumstats}
\alias{list_sumstats}
\title{List munged summary statistics}
\usage{
list_sumstats(
  save_dir = getwd(),
  pattern = "*.tsv.gz$",
  ids_from_file = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{save_dir}{Top-level directory to recursively search
for summary statistics files within.}

\item{pattern}{Regex pattern to search for files with.}

\item{ids_from_file}{Try to extract dataset IDs from file names.
If \code{FALSE}, will infer IDs from the directory names instead.}

\item{verbose}{Print messages.}
}
\value{
Named vector of summary stats paths.
}
\description{
Searches for and lists local GWAS summary statistics files munged by
\link[MungeSumstats]{format_sumstats} or
\link[MungeSumstats]{import_sumstats}.
}
\examples{
save_dir <- system.file("extdata",package = "MungeSumstats")
munged_files <- MungeSumstats::list_sumstats(save_dir = save_dir)

}
