% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sample_size_n.R
\name{compute_sample_size_n}
\alias{compute_sample_size_n}
\title{Add user supplied sample size}
\usage{
compute_sample_size_n(sumstats_dt, method, force_new = FALSE)
}
\arguments{
\item{sumstats_dt}{Summary statistics data.table.}

\item{method}{Method for computing (effective) sample size.

\itemize{

\item{"ldsc" : \cr}{
\eqn{Neff = (N_CAS+N_CON) * (N_CAS/(N_CAS+N_CON)) /
 mean((N_CAS/(N_CAS+N_CON))[(N_CAS+N_CON)==max(N_CAS+N_CON)]))}\cr
\href{https://github.com/bulik/ldsc/issues/95}{
bulik/ldsc GitHub Issue}
\href{https://github.com/bulik/ldsc/blob/aa33296abac9569a6422ee6ba7eb4b902422cc74/munge_sumstats.py#L321}{
bulik/ldsc GitHub code}
}

\item{"giant" : \cr}{
\eqn{Neff = 2 / (1/N_CAS + 1/N_CON)}\cr
\href{https://www.nature.com/articles/nprot.2014.071}{
Winkler et al. 2014, Nature}
}

\item{"metal" : \cr}{
\eqn{Neff = 4 / (1/N_CAS + 1/N_CON)}\cr
\href{https://pubmed.ncbi.nlm.nih.gov/20616382/}{
Willer et al. 2010, Bioinformatics}
}

\item{"sum" : \cr}{
\eqn{N = N_CAS + N_CON}\cr
Simple summation of cases and controls
that does not account for class imbalance.
}

\item{"\\<integer\\>" : \cr}{
\code{N = \\<integer\\>}\cr
If method is a positive integer, it will be used as N
for every row.
}

}}

\item{force_new}{If "Neff" (or "N") already exists in \code{sumstats_dt},
replace it with the recomputed version.}
}
\value{
No return
}
\description{
Add user supplied sample size
}
\keyword{internal}
