test_that("Input has correct headers", {
    ## Call uses reference genome as default with more than 2GB of memory,
    ## which is more than what 32-bit Windows can handle so remove tests
    is_32bit_windows <-
        .Platform$OS.type == "windows" && .Platform$r_arch == "i386"
    if (!is_32bit_windows) {
        file <- tempfile()
        # write the Educational Attainment GWAS to a temp file for testing
        eduAttainOkbay <- readLines(system.file("extdata", "eduAttainOkbay.txt",
            package = "MungeSumstats"
        ))
        writeLines(eduAttainOkbay, con = file)
        # read it in and correct column headers
        sumstats_dt <- data.table::fread(file)
        names(sumstats_dt) <- c(
            "SNP", "CHR", "BP", "A1", "A2",
            "FRQ", "BETA", "SE", "P"
        )
        data.table::fwrite(x = sumstats_dt, file = file, sep = "\t")
        # Run MungeSumstats code
        reformatted <- MungeSumstats::format_sumstats(file,
            ref_genome = "GRCh37",
            on_ref_genome = FALSE,
            strand_ambig_filter = FALSE,
            bi_allelic_filter = FALSE,
            allele_flip_check = FALSE,
            dbSNP=144
        )
        reformatted_dt <- data.table::fread(reformatted)
        expect_equal(
            all.equal(reformatted_dt, sumstats_dt, ignore.row.order = TRUE),
            TRUE
        )
    }    
    else{
        expect_equal(is_32bit_windows, TRUE)
    }
})
