% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiRNAflow-package.R
\docType{package}
\name{MultiRNAflow-package}
\alias{MultiRNAflow}
\alias{MultiRNAflow-package}
\title{MultiRNAflow: An R package for integrated analysis of temporal RNA-seq data with multiple biological conditions}
\description{
Our R package MultiRNAflow provides an easy to use unified framework allowing to automatically make both unsupervised and supervised (DE) analysis for datasets with an arbitrary number of biological conditions and time points. In particular, our code makes a deep downstream analysis of DE information, e.g. identifying temporal patterns across biological conditions and DE genes which are specific to a biological condition for each time.
}
\details{
The main functions are:
\itemize{
\item \code{\link{DATAnormalization}} - to normalize raw count data
\item \code{\link{PCAanalysis}} - to perform PCA analysis
with \code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}
\item \code{\link{HCPCanalysis}} - to perform hierarchical clustering with
\code{\link[FactoMineR:HCPC]{FactoMineR::HCPC()}}
\item \code{\link{MFUZZanalysis}} - to perform temporal clustering with
\code{\link[Mfuzz:mfuzz.plot2]{Mfuzz::mfuzz.plot2()}}
\item \code{\link{DEanalysisGlobal}} - to perform differential analysis with
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}
\item \code{\link{GSEAQuickAnalysis}} - to perform enrichment analysis with
\code{\link[gprofiler2:gost]{gprofiler2::gost()}}
\item \code{\link{GSEApreprocessing}} - to return preprocessing file
for official software and online tools performing enrichment analysis
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/loubator/MultiRNAflow}
  \item Report bugs at \url{https://github.com/loubator/MultiRNAflow/issues}
}

}
\author{
\strong{Maintainer}: Rodolphe Loubaton \email{loubaton.rodolphe@gmail.com} (\href{https://orcid.org/0000-0002-1442-7270}{ORCID})

Authors:
\itemize{
  \item Nicolas Champagnat \email{nicolas.champagnat@inria.fr} (\href{https://orcid.org/0000-0002-5128-2357}{ORCID}) [thesis advisor]
  \item Laurent Vallat \email{vallat@unistra.fr} (\href{https://orcid.org/0000-0002-5226-7706}{ORCID}) [thesis advisor]
  \item Pierre Vallois \email{pierre.vallois@univ-lorraine.fr} (\href{https://orcid.org/0000-0002-2123-0142}{ORCID})
}

Other contributors:
\itemize{
  \item Région Grand Est [funder]
  \item Cancéropôle Est [funder]
}

}
\keyword{internal}
