% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEAQuickAnalysis.R
\name{GSEAQuickAnalysis}
\alias{GSEAQuickAnalysis}
\title{GSEA analysis with gprofiler2}
\usage{
GSEAQuickAnalysis(
  Internet.Connection = FALSE,
  SEresDE,
  ColumnsCriteria = 1,
  ColumnsLog2ordered = NULL,
  Set.Operation = "union",
  Organism = "hsapiens",
  MaxNumberGO = 20,
  Background = FALSE,
  Display.plots = TRUE,
  Save.plots = FALSE
)
}
\arguments{
\item{Internet.Connection}{\code{TRUE} or \code{FALSE}.
\code{FALSE} by default. If the user is sure to have an internet connection,
the user must set \code{Internet.Connection=TRUE}, otherwise, the algorithm
will not run.}

\item{SEresDE}{A SummarizedExperiment class object. Output from
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
(see \code{Examples}).}

\item{ColumnsCriteria}{A vector of integers where each integer indicates
a column of  \code{SummarizedExperiment::rowData(SEresDE)}.
These columns should either contain only binary values, or may contain other
numerical value, in which case extracted outputs from \code{SEresDE}
will be those with >0 values (see \code{Details}).}

\item{ColumnsLog2ordered}{\code{NULL} or a vector of integers.
If \code{ColumnsLog2ordered} is a vector of integers, it corresponds to
the columns number of \code{Res.DE.analysis$DE.results}, the output of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}},
which must contains \eqn{log_2} fold change values (see \code{Details}).}

\item{Set.Operation}{A character. The user must choose between "union"
(default), "intersect", "setdiff" (see \code{Details}).}

\item{Organism}{A character indicating the organism
where data were taken from.
See vignette of the R package \code{gprofiler2} for supported organisms.
See \code{\link[gprofiler2:gost]{gprofiler2::gost()}}.}

\item{MaxNumberGO}{An integer.
The user can select the \code{MaxNumberGO} most important Gene Ontology
(GO) names to be plotted in a lollipop graph.
By default, \code{MaxNumberGO=20}.}

\item{Background}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the statistical enrichment analysis to find
over-representation of functions from Gene Ontology (GO) and
biological pathways (e.g. KEGG) will be done by comparing the functions and
biological pathways among the selected DE genes with those associated with
all genes in \code{Res.DE.analysis$DE.results}.
If \code{FALSE}, the statistical enrichment analysis will be done
by comparing the functions and biological pathways among the selected
DE genes with all functions and biological pathways included in the database
of \code{gprofiler2} (link in \code{See Also}).
See also \code{\link[gprofiler2:gost]{gprofiler2::gost()}}.}

\item{Display.plots}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{Save.plots}{\code{TRUE} or \code{FALSE} or a Character.
If \code{Save.plots=TRUE} and the output \code{path.result} of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}} is not \code{NULL}, all files will be saved in
"2_SupervisedAnalysis_\code{Name.folder.DE}/
2-5_Enrichment_analysis_\code{Name.folder.DE}/
2-5-1_gprofiler2_results_\code{Name.folder.DE}", with \code{Name.folder.DE}
an input of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
If \code{Save.plots} is a character, it must be a path and all files
will be saved in the sub-folder "gprofiler2_results_\code{Name.folder.DE}".
Otherwise, the different files will not be saved.}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresDE} with
\itemize{
\item a data.frame which contains the outputs of
\code{\link[gprofiler2:gost]{gprofiler2::gost()}}
\item a Manhattan plot showing all GO names according to their pvalue
\item a lollipop graph showing the \code{MaxNumberGO} most important GO.
}

saved in the metadata \code{Results[[2]][[5]]} of \code{SEresDE}.

The Manhattan plot and the lollipop graph are plotted if
\code{Display.plots=TRUE}.
}
\description{
The function realizes, from the outputs of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}},
an enrichment analysis (GSEA) of a subset of genes with
the R package \code{gprofiler2}.
}
\details{
If \code{ColumnsLog2ordered} is a vector of integers,
the rows of \code{Res.DE.analysis$DE.results} (corresponding to genes)
will be decreasingly ordered according to the sum of absolute \eqn{log_2}
fold change (the selected columns must contain \eqn{log_2} fold change
values) before the enrichment analysis.
The enrichment analysis will take into account the genes order as
the first genes will be considered to have the highest biological importance
and the last genes the lowest.
See the input \code{ordered_query} of
\code{\link[gprofiler2:gost]{gprofiler2::gost()}}
and the vignette of \code{gprofiler2} for more details.

We have the following three cases:
\itemize{
\item If \code{Set.Operation="union"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that the sum of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having at least one ’1’
in one of the selected columns.
\item If \code{Set.Operation="intersect"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that the product of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having ’1’
in all of the selected columns.
\item If \code{Set.Operation="setdiff"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that only one element of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having ’1’
in only one of the selected columns.
}
}
\examples{
## data importation
data(RawCounts_Antoszewski2022_MOUSEsub500)
## No time points. We take only two groups for the speed of the example
dataT1wt <- RawCounts_Antoszewski2022_MOUSEsub500[seq_len(200), seq_len(7)]

## Preprocessing with Results of DEanalysisGlobal()
resDATAprepSE <- DATAprepSE(RawCounts=dataT1wt,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)

##------------------------------------------------------------------------##
## Internet is needed in order to run the following lines of code because
## gprofileR2 needs an internet connection
## DE analysis
# resDET1wt <- DEanalysisGlobal(SEres=resDATAprepSE,
#                               pval.min=0.05,
#                               pval.vect.t=NULL,
#                               log.FC.min=1,
#                               LRT.supp.info=FALSE,
#                               Plot.DE.graph=FALSE,
#                               path.result=NULL,
#                               Name.folder.DE=NULL)
#########
# resGs <- GSEAQuickAnalysis(Internet.Connection=TRUE,
#                            SEresDE=resDET1wt,
#                            ColumnsCriteria=3,
#                            ColumnsLog2ordered=NULL,
#                            Set.Operation="union",
#                            Organism="mmusculus",
#                            MaxNumberGO=20,
#                            Background=FALSE,
#                            Display.plots=TRUE,
#                            Save.plots=FALSE)
}
\seealso{
The function uses the R package \code{gprofiler2}
\url{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}.

The R package \code{gprofiler2} provides an R interface to the web toolset
g:Profiler \url{https://biit.cs.ut.ee/gprofiler/gost}.
}
