% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEplotHeatmaps.R
\name{DEplotHeatmaps}
\alias{DEplotHeatmaps}
\title{Heatmaps of DE genes}
\usage{
DEplotHeatmaps(
  SEresDE,
  ColumnsCriteria = 2,
  Set.Operation = "union",
  NbGene.analysis = 20,
  Color.Group = NULL,
  SizeLabelRows = 5,
  SizeLabelCols = 5,
  Display.plots = TRUE,
  Save.plots = FALSE
)
}
\arguments{
\item{SEresDE}{A SummarizedExperiment class object. Output from
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
(see \code{Examples}).}

\item{ColumnsCriteria}{A vector of integers where each integer indicates
a column of  \code{SummarizedExperiment::rowData(SEresDE)}.
These columns should either contain only binary values, or may contain other
numerical value, in which case extracted outputs from \code{SEresDE}
will be those with >0 values (see \code{Details}).}

\item{Set.Operation}{A character.
The user must choose between "union" (default), "intersect", "setdiff"
(see \code{Details}).}

\item{NbGene.analysis}{An integer or \code{NULL}.
If it is an integer, the heatmaps will be plotted with the
\code{NbGene.analysis} genes which have the highest sum of absolute
log2 fold change, among the DE genes selected using \code{ColumnsCriteria}
and \code{Set.Operation}.
If \code{NULL}, all the DE selected genes will be used for both heatmaps.}

\item{Color.Group}{\code{NULL} or a data.frame with \eqn{N_{bc}} rows and
two columns where \eqn{N_{bc}} is the number of biological conditions.
If \code{Color.Group} is a data.frame, the first column must contain
the name of each biological condition and the second column must contain
the colors associated to each biological condition.
If \code{Color.Group=NULL}, the function will automatically attribute
a color for each biological condition.
If samples belong to different time points only,
\code{Color.Group} will not be used.}

\item{SizeLabelRows}{Numeric >0.
Size of the labels for the genes in the heatmaps.}

\item{SizeLabelCols}{Numeric >0.
Size of the labels for the samples in the heatmaps.}

\item{Display.plots}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{Save.plots}{TRUE or FALSE or a Character.
If \code{Save.plots=FALSE}, the different files will not be saved.
If \code{Save.plots=TRUE} and the \code{path.result} of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
is not NULL, all files will be saved in
"2_SupervisedAnalysis_\code{Name.folder.DE}/
2-4_Supplementary_Plots_\code{Name.folder.DE}/Plots_Heatmaps".
If \code{Save.plots} is a character, it must be a path and
all files will be saved in the sub-folder "Plots_Heatmaps".}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresDE} with two heatmaps
saved in the metadata \code{Results[[2]][[4]]} of \code{SEresDE}
\itemize{
\item a correlation heatmap between samples (correlation heatmap)
\item a heatmap across samples and genes called Zscore heatmap,
for a subset of genes that can be selected by the user.
}

The two heatmaps are plotted if \code{Display.plots=TRUE}.
The second heatmap is build from the normalized
count data after being both centered and scaled (Zscore).
}
\description{
The function returns two heatmaps:
one heatmap of gene expressions between samples and selected genes and
a correlation heatmap between samples from the output of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
\details{
We have the following three cases:
\itemize{
\item If \code{Set.Operation="union"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that the sum of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having at least one ’1’
in one of the selected columns.
\item If \code{Set.Operation="intersect"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that the product of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having ’1’
in all of the selected columns.
\item If \code{Set.Operation="setdiff"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that only one element of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having ’1’
in only one of the selected columns.
}
}
\examples{
## data importation
data("RawCounts_Antoszewski2022_MOUSEsub500")
## No time points. We take only two groups for the speed of the example
dataT1wt <- RawCounts_Antoszewski2022_MOUSEsub500[seq_len(200), seq_len(7)]

## Preprocessing with Results of DEanalysisGlobal()
resDATAprepSE <- DATAprepSE(RawCounts=dataT1wt,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)
##------------------------------------------------------------------------##
## DE analysis
resDET1wt <- DEanalysisGlobal(SEres=resDATAprepSE,
                              pval.min=0.05,
                              pval.vect.t=NULL,
                              log.FC.min=1,
                              LRT.supp.info=FALSE,
                              Plot.DE.graph=FALSE,
                              path.result=NULL,
                              Name.folder.DE=NULL)

##------------------------------------------------------------------------##
resHeatmap <- DEplotHeatmaps(SEresDE=resDET1wt,
                             ColumnsCriteria=3, ## Specific genes N1haT1ko
                             Set.Operation="union",
                             NbGene.analysis=20,
                             Color.Group=NULL,
                             SizeLabelRows=5,
                             SizeLabelCols=5,
                             Display.plots=TRUE,
                             Save.plots=FALSE)
}
\seealso{
The function calls the function
\code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}
in order to plot the Heatmaps.
}
