% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_se}
\alias{add_se}
\title{Method to add a \code{SummarizedExperiment} to \code{MultiDataSet}.}
\usage{
add_se(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  sample.tables = NULL,
  feature.tables = NULL,
  warnings = TRUE,
  overwrite = FALSE,
  GRanges
)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{set}{Object derived from \code{SummarizedExperiment} to be used to fill the slot.}

\item{dataset.type}{Character with the type of data of the omic set (e.g. expression, methylation...)}

\item{dataset.name}{Character with the specific name for this set (NULL by default). It is useful when there 
are several sets of the same type (e.g. multiple expression assays)}

\item{sample.tables}{Character with the names of the slots with sample data besides colData.}

\item{feature.tables}{Character with the names of the slots with feature data besides rowData.}

\item{warnings}{Logical to indicate if warnings will be displayed.}

\item{overwrite}{Logical to indicate if the set stored in the slot will be overwritten.}

\item{GRanges}{\code{GenomicRanges} to be included in rowRanges slot.}
}
\value{
A new \code{MultiDataSet} with a slot filled.
}
\description{
This method adds or overwrites a slot of a \code{MultiDataSet} with the content 
of the given \code{SummarizedExperiment}.
}
\examples{
multi <- createMultiDataSet()
se <- SummarizedExperiment::SummarizedExperiment(matrix(runif(10), 5))
multi <- add_se(multi, se, "exampledata", GRanges = NA)
}
