% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetBy-methods.R,
%   R/MultiAssayExperiment-subset.R
\name{subsetBy}
\alias{subsetBy}
\alias{[,MultiAssayExperiment,ANY-method}
\alias{subsetByColData}
\alias{subsetByRow}
\alias{subsetByColumn}
\alias{subsetByAssay}
\alias{subset}
\alias{subsetByRowData}
\alias{subsetByRow,ExperimentList,ANY-method}
\alias{subsetByRow,ExperimentList,list-method}
\alias{subsetByRow,ExperimentList,List-method}
\alias{subsetByRow,ExperimentList,logical-method}
\alias{subsetByColumn,ExperimentList,list-method}
\alias{subsetByColumn,ExperimentList,List-method}
\alias{subsetByColumn,ExperimentList,logical-method}
\alias{subsetByAssay,ExperimentList-method}
\alias{subsetByColData,MultiAssayExperiment,ANY-method}
\alias{subsetByColData,MultiAssayExperiment,character-method}
\alias{subsetByRow,MultiAssayExperiment,ANY-method}
\alias{subsetByRow,MultiAssayExperiment,list-method}
\alias{subsetByRow,MultiAssayExperiment,List-method}
\alias{subsetByColumn,MultiAssayExperiment,ANY-method}
\alias{subsetByAssay,MultiAssayExperiment-method}
\alias{subsetByRowData,MultiAssayExperiment,character,character-method}
\alias{intersectByRowData}
\alias{intersectByRowData,MultiAssayExperiment,character,character-method}
\alias{[,MultiAssayExperiment,ANY,ANY,ANY-method}
\alias{[[,MultiAssayExperiment,ANY,ANY-method}
\alias{[[<-,MultiAssayExperiment,ANY,ANY-method}
\alias{[<-,MultiAssayExperiment,ANY,ANY,ANY-method}
\title{Subsetting a MultiAssayExperiment object}
\usage{
subsetByRow(x, y, ...)

subsetByRowData(x, y, rowDataCol, ...)

subsetByColData(x, y)

subsetByColumn(x, y)

subsetByAssay(x, y)

\S4method{subsetByRow}{ExperimentList,ANY}(x, y, ...)

\S4method{subsetByRow}{ExperimentList,list}(x, y, ...)

\S4method{subsetByRow}{ExperimentList,List}(x, y, ...)

\S4method{subsetByRow}{ExperimentList,logical}(x, y, ...)

\S4method{subsetByColumn}{ExperimentList,list}(x, y)

\S4method{subsetByColumn}{ExperimentList,List}(x, y)

\S4method{subsetByColumn}{ExperimentList,logical}(x, y)

\S4method{subsetByAssay}{ExperimentList}(x, y)

\S4method{subsetByColData}{MultiAssayExperiment,ANY}(x, y)

\S4method{subsetByColData}{MultiAssayExperiment,character}(x, y)

\S4method{subsetByRow}{MultiAssayExperiment,ANY}(x, y, i = TRUE, ...)

\S4method{subsetByRow}{MultiAssayExperiment,list}(x, y, ...)

\S4method{subsetByRow}{MultiAssayExperiment,List}(x, y, ...)

\S4method{subsetByColumn}{MultiAssayExperiment,ANY}(x, y)

\S4method{subsetByAssay}{MultiAssayExperiment}(x, y)

\S4method{subsetByRowData}{MultiAssayExperiment,character,character}(x, y, rowDataCol, i = TRUE, ...)

intersectByRowData(x, y, rowDataCol, i, ...)

\S4method{intersectByRowData}{MultiAssayExperiment,character,character}(x, y, rowDataCol, i = TRUE, ...)

\S4method{[}{MultiAssayExperiment,ANY,ANY,ANY}(x, i, j, k, ..., drop = FALSE)

\S4method{[[}{MultiAssayExperiment,ANY,ANY}(x, i, j, ...)

\S4method{[[}{MultiAssayExperiment,ANY,ANY}(x, i, j, ...) <- value

\S4method{[}{MultiAssayExperiment,ANY,ANY,ANY}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A \code{MultiAssayExperiment} or \code{ExperimentList}}

\item{y}{Either a \code{character}, \code{integer}, \code{logical}, \code{list}, \code{List},
or \code{GRanges} object for subsetting by rows \emph{within the experiments}}

\item{...}{Additional arguments passed on to lower level functions.}

\item{rowDataCol}{\code{character(1)} The name of the column in the \code{rowData}.
If the column is not present, the experiment will be skipped. When
\code{rowDataCol} is \code{"rownames"} or \code{"row.names"}, the values of \code{y} will
be matched with the row names in the \code{rowData} of the experiment.}

\item{i}{For the \code{subsetByRow} and \code{subsetByRowData} \code{MultiAssayExperiment}
methods, either a \code{character}, \code{logical}, or \code{numeric} vector to selectively
subset experiments with \code{y} (default is \code{TRUE}). For \strong{bracket} (\code{[})
methods, see \code{y} input.}

\item{j}{Either a \code{character}, \code{logical}, or \code{numeric} vector
for subsetting by \code{colData} rows. See details for more information.}

\item{k}{Either a \code{character}, \code{logical}, or \code{numeric} vector
for subsetting by assays}

\item{drop}{logical (default FALSE) whether to drop all empty assay elements
in the \code{ExperimentList}}

\item{value}{An assay compatible with the MultiAssayExperiment API}
}
\value{
\verb{subsetBy*}: operations are endomorphic and return either
\code{MultiAssayExperiment} or \code{ExperimentList} depending on the
input.
}
\description{
A set of functions for extracting and dividing a
\code{MultiAssayExperiment}
}
\details{
Subsetting a \code{MultiAssayExperiment} by the \strong{j} index can yield a call
to either \code{subsetByColData} or \code{subsetByColumn}. For vector inputs,
the subset will be applied to the \code{colData} rows. For \code{List}-type
inputs, the List will be applied to each of the elements in the
\code{ExperimentList}.
The order of the subsetting elements in the
\code{List} must match that of the \code{ExperimentList} in the
\code{MultiAssayExperiment}.
\itemize{
\item \code{subsetBycolData}: Select biological units by vector input types
\item \code{subsetByColumn}: Select observations by assay or for each assay
\item \code{subsetByRow}: Select rows by assay or for each assay
\item \code{subsetByAssay}: Select experiments
\item \code{subsetByRowData}: Select rows by values in the rowData
\item \code{intersectByRowData}: Intersect with values in the rowData
}
}
\section{rowData}{


Some assays may have additional metadata associated with the rows.
This metadata is stored in the \code{rowData} slot of the object, typically a
\code{SummarizedExperiment} or \code{RangedSummarizedExperiment}.

\code{subsetByRowData} allows the user to subset the rows of the assays
based on the values in the \code{rowData}.

\code{intersectByRowData} is a special case of \code{subsetByRowData} where
the \code{rowData} values are intersected with the \code{y} values. Naturally,
the \code{y} values are expected to be of type \code{character}.

Note that \code{rowDataCol} allows the user to specify a particular
column from which to extract the values for subsetting. This column
name must be consistent across assays. If the column is not present
in an assay, the assay will be skipped and considered a no-op. Assays
are also skipped when there are no values in the \code{rowData} that match
the \code{y} values.

Note that the use of \code{rownames} or \code{row.names} as the \code{rowDataCol} requires
that the assay class have a \code{rownames()} method.
}

\examples{
## Load the example MultiAssayExperiment
example("MultiAssayExperiment")

## Using experiment names
subsetByAssay(mae, "Affy")

## Using numeric indices
subsetByAssay(mae, 1:2)

## Using a logical vector
subsetByAssay(mae, c(TRUE, FALSE, TRUE))

## Subset by character vector (Jack)
subsetByColData(mae, "Jack")

## Subset by numeric index of colData rows (Jack and Bob)
subsetByColData(mae, c(1, 3))

## Subset by logical indicator of colData rows (Jack and Jill)
subsetByColData(mae, c(TRUE, TRUE, FALSE, FALSE))

subsetByColumn(mae, list(Affy = 1:2,
    Methyl450k = c(3,5,2), RNASeqGene = 2:4, GISTIC = 1))

subsetWith <- S4Vectors::mendoapply(`[`, colnames(mae),
    MoreArgs = list(1:2))
subsetByColumn(mae, subsetWith)

## Use a GRanges object to subset rows where ranged data present
egr <- GenomicRanges::GRanges(seqnames = "chr2",
    IRanges::IRanges(start = 11, end = 13), strand = "-")
subsetByRow(mae, egr)

## Use a logical vector (recycling used)
subsetByRow(mae, c(TRUE, FALSE))

## Use a character vector
subsetByRow(mae, "ENST00000355076")

## Use i index to selectively subsetByRow
subsetByRow(mae, "ENST00000355076", i = c(TRUE, TRUE, FALSE, FALSE))

## only subset assays with rowRanges with GRanges input
subsetByRow(mae, egr, i = hasRowRanges(mae))

## Use i index to selectively subsetByRowData
subsetByRowData(
    mae, "ENST00000355076", "rownames", i = "Affy"
)

## use miniACC as example MAE
data("miniACC")

## intersect values of y with rownames in rowData
intersectByRowData(
    x = miniACC,
    y = c("G6PD", "PETN"),
    rowDataCol = "rownames",
    i = c("RNASeq2GeneNorm", "gistict")
)

## no-op when rowDataCol is not present or there is no data
intersectByRowData(
    x = miniACC, y = c("G6PD", "PETN"), rowDataCol = "Genes",
    i = c("RNASeq2GeneNorm", "gistict")
)
}
