% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{numberEmptyScans}
\alias{numberEmptyScans}
\title{number of empty MS1 scans (MS:4000099), number of empty MS2 scans 
(MS:4000100), or number of empty MS3 scans (MS:4000101)}
\usage{
numberEmptyScans(spectra, msLevel = 1L, ...)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{...}{not used here}
}
\value{
\code{numeric(1)}
}
\description{
MS:4000099 \cr
"Number of MS1 scans where the scans' peaks intensity sums to 0 
(i.e. no peaks or only 0-intensity peaks)." [PSI:MS] \cr

MS:4000100 \cr
"Number of MS2 scans where the scans' peaks intensity sums to 0 
(i.e. no peaks or only 0-intensity peaks)." [PSI:MS] \cr

MS:4000101 \cr
"Number of MS3 scans where the scans' peaks intensity sums to 0 
(i.e. no peaks or only 0-intensity peaks)." [PSI:MS] \cr


The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the intensities per entry are obtained, \cr
(3) the number of intensity entries that are \code{NULL}, \code{NA}, or 
that have a sum of \code{0} are obtained and returned.
}
\details{
MS:4000099 \cr
is_a: MS:4000003 ! single value \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000021 ! MS1 metric \cr
relationship: has_units UO:0000189 ! count unit \cr
relationship: has_value_type xsd:integer ! The allowed value-type for this 
CV term \cr

MS:4000100 \cr
is_a: MS:4000003 ! single value \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000022 ! MS2 metric \cr
relationship: has_units UO:0000189 ! count unit \cr
relationship: has_value_type xsd:integer ! The allowed value-type for this 
CV term \cr

MS:4000101 \cr
is_a: MS:4000003 ! single value \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_units UO:0000189 ! count unit \cr
relationship: has_value_type xsd:integer ! The allowed value-type for this CV 
term \cr

#' For *MS:4000099*, \code{msLevel} is set to 1. For *MS:4000100*, 
\code{msLevel} is set to 2. For *MS:4000101*, \code{msLevel} is set to 3.

An attribute containing the PSI:MS term will only be returned if 
\code{msLevel} is either 1, 2, or 3.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
sps <- Spectra(spd)
numberEmptyScans(spectra = sps, msLevel = 1L)
numberEmptyScans(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
