% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{medianTicRtIqr}
\alias{medianTicRtIqr}
\title{median of TIC values in the RT range in which the middle half of 
quantification data points are identified (MS:4000158)}
\usage{
medianTicRtIqr(
  spectra,
  msLevel = 1L,
  identificationLevel = c("all", "identified", "unidentified"),
  ...
)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{identificationLevel}{\code{character(1)}, one of \code{"all"}, 
\code{"identified"}, or \code{"unidentified"}}

\item{...}{not used here}
}
\value{
\code{numeric(1)}
}
\description{
MS:4000158 \cr
"Median of TIC values in the RT range in which half of quantification data 
points are identified (RT values of Q1 to Q3 of identifications). These 
data points may be for example XIC profiles, isotopic pattern areas, or 
reporter ions (see MS:1001805). The used type should be noted in the metadata 
or analysis methods section of the recording file for the respective run. 
In case of multiple acceptance criteria (FDR) available in proteomics, 
PSM-level FDR should be used for better comparability." [PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the \code{Spectra} object is ordered according to the retention time, \cr 
(3) the features between the 1st and 3rd quartile are obtained 
(half of the features that are present in the \code{Spectra} object), \cr 
(4) the ion count of the features within the 1st and 3rd quartile is 
obtained, \cr 
(5) the median value of the ion count is calculated (\code{NA} values are 
removed) and the median value is returned. \cr
}
\details{
MS:4000158 \cr
is_a: MS:4000001 ! QC metric \cr
is_a: MS:4000003 ! single value \cr
is_a: MS:4000008 ! ID based \cr

The function \code{medianTicRtIqr} uses the function [ionCount()] as an 
equivalent to the TIC.

An attribute containing the PSI:MS term will only be returned if 
\code{identificationLevel} is \code{"identified"}.
}
\note{
The \code{Spectra} object might contain features that were not identified. If
the calculation needs to be done according to *MS:4000158*, the 
\code{Spectra} object should be prepared accordingly, i.e. being subsetted to
spectra with identification data.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
medianTicRtIqr(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
