% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping-functions.R
\name{groupSimilarityMatrix}
\alias{groupSimilarityMatrix}
\title{Group rows of a diagonal matrix using a threshold}
\usage{
groupSimilarityMatrix(x, threshold = 0.9, full = TRUE, ...)
}
\arguments{
\item{x}{symmetrix \code{numeric} \code{matrix}.}

\item{threshold}{\code{numeric(1)} above which rows in \code{x} should be grouped.}

\item{full}{\code{logical(1)} whether the full matrix should be considered, or
just the upper triangular matrix (including the diagonal).}

\item{...}{ignored.}
}
\value{
\code{integer} same length than \code{nrow(x)}, grouped elements (rows) defined
by the same value.
}
\description{
This function groups elements (rows or columns) of a diagonal matrix, such as
a pairwise correlation matrix or similarity matrix, with a value \verb{>= threshold}. This creates clusters of elements in which \strong{all} elements have
a value \verb{>= threshold} with \strong{any} other element in that cluster. On a
correlation matrix (such as created with \code{cor}) it will generate small
clusters of highly correlated elements. Note however that single elements in
one cluster could also have a correlation \verb{>= threshold} to another element
in another cluster. The average similarity to its own cluster will however
be higher to that of the other.
}
\details{
The algorithm is defined as follows:
\itemize{
\item all pairs of values in \code{x} which are \verb{>= threshold} are identified and
sorted decreasingly.
\item starting with the pair with the highest correlation, groups are defined:
\item if none of the two is in a group, both are put into the same new group.
\item if one of the two is already in a group, the other is put into the same
group if \strong{all} correlations of it to that group are \verb{>= threshold}
(and are not \code{NA}).
\item if both are already in the same group nothing is done.
\item if both are in different groups: an element is put into the group of the
other if a) all correlations of it to members of the other's group
are not \code{NA} and \verb{>= threshold} \strong{and} b) the average correlation to the
other group is larger than the average correlation to its own group.
}

This ensures that groups are defined in which all elements have a correlation
\verb{>= threshold} with each other and the correlation between members of the
same group is maximized.
}
\examples{

x <- rbind(
    c(1, 0.9, 0.6, 0.8, 0.5),
    c(0.9, 1, 0.7, 0.92, 0.8),
    c(0.6, 0.7, 1, 0.91, 0.7),
    c(0.8, 0.92, 0.91, 1, 0.9),
    c(0.5, 0.8, 0.7, 0.9, 1)
    )

groupSimilarityMatrix(x, threshold = 0.9)

groupSimilarityMatrix(x, threshold = 0.1)

## Add also a correlation between 3 and 2
x[2, 3] <- 0.9
x[3, 2] <- 0.9
x
groupSimilarityMatrix(x, threshold = 0.9)

## Add a higher correlation between 4 and 5
x[4, 5] <- 0.99
x[5, 4] <- 0.99
x
groupSimilarityMatrix(x, threshold = 0.9)

## Increase correlation between 2 and 3
x[2, 3] <- 0.92
x[3, 2] <- 0.92
x
groupSimilarityMatrix(x, threshold = 0.9) ## Don't break previous cluster!
}
\seealso{
Other grouping operations: 
\code{\link{groupClosest}()},
\code{\link{groupConsecutive}()},
\code{\link{groupSimilarityMatrixTree}()}
}
\author{
Johannes Rainer
}
\concept{grouping operations}
