% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refineCentroids.R
\name{refineCentroids}
\alias{refineCentroids}
\title{Refine Peak Centroids}
\usage{
refineCentroids(x, y, p, k = 2L, threshold = 0.33, descending = FALSE)
}
\arguments{
\item{x}{\code{numeric}, i.e. m/z values.}

\item{y}{\code{numeric}, i.e. intensity values.}

\item{p}{\code{integer}, indices of identified peaks/local maxima.}

\item{k}{\code{integer(1)}, number of values left and right of the peak that
should be considered in the weighted mean calculation.}

\item{threshold}{\code{double(1)}, proportion of the maximal peak intensity.
Just values above are used for the weighted mean calclulation.}

\item{descending}{\code{logical}, if \code{TRUE} just values between the nearest
valleys around the peak centroids are used.}
}
\description{
This function refines the centroided values of a peak by weighting the y
values in the neighbourhood that belong most likely to the same peak.
}
\details{
For \code{descending = FALSE} the function looks for the \code{k} nearest neighbouring
data points and use their \code{x} for weighted mean with their corresponding \code{y}
values as weights for calculation of the new peak centroid. If \code{k} are chosen
too large it could result in skewed peak centroids, see example below.
If \code{descending = TRUE} is used the \code{k} should be general larger because it is
trimmed automatically to the nearest valleys on both sides of the peak so the
problem with skewed centroids is rare.
}
\examples{
ints <- c(5, 8, 12, 7, 4, 9, 15, 16, 11, 8, 3, 2, 3, 9, 12, 14, 13, 8, 3)
mzs <- seq_along(ints)

plot(mzs, ints, type = "h")

pidx <- as.integer(c(3, 8, 16))
points(mzs[pidx], ints[pidx], pch = 16)

## Use the weighted average considering the adjacent mz
mzs1 <- refineCentroids(mzs, ints, pidx,
                        k = 2L, descending = FALSE, threshold = 0)
mzs2 <- refineCentroids(mzs, ints, pidx,
                        k = 5L, descending = FALSE, threshold = 0)
mzs3 <- refineCentroids(mzs, ints, pidx,
                        k = 5L, descending = TRUE, threshold = 0)
points(mzs1, ints[pidx], col = "red", type = "h")
## please recognize the artificial moved centroids of the first peak caused
## by a too large k, here
points(mzs2, ints[pidx], col = "blue", type = "h")
points(mzs3, ints[pidx], col = "green", type = "h")
legend("topright",
       legend = paste0("k = ", c(2, 5, 5),
                       ", descending =", c("FALSE", "FALSE", "TRUE")),
       col = c("red", "blue", "green"), lwd = 1)
}
\seealso{
Other extreme value functions: 
\code{\link{.peakRegionMask}()},
\code{\link{localMaxima}()},
\code{\link{valleys}()}
}
\author{
Sebastian Gibb, Johannes Rainer
}
\concept{extreme value functions}
