% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendOfflineSql.R
\name{MsBackendOfflineSql}
\alias{MsBackendOfflineSql}
\alias{MsBackendOfflineSql-class}
\alias{backendInitialize,MsBackendOfflineSql-method}
\title{SQL-based MS backend without active database connection}
\usage{
MsBackendOfflineSql()

\S4method{backendInitialize}{MsBackendOfflineSql}(
  object,
  drv = NULL,
  dbname = character(),
  user = character(),
  password = character(),
  host = character(),
  port = NA_integer_,
  data,
  ...
)
}
\arguments{
\item{object}{A \code{MsBackendOfflineSql} object.}

\item{drv}{A \emph{DBI} database driver object (such as \code{SQLite()} from the
\code{RSQLite} package or \code{MariaDB()} from the \code{RMariaDB} package). See
\code{\link[DBI:dbConnect]{DBI::dbConnect()}} for more information.}

\item{dbname}{\code{character(1)} with the name of the database. Passed directly
to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{user}{\code{character(1)} with the user name for the database. Passed
directly to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{password}{\code{character(1)} with the password for the database. Note
that this password is stored (unencrypted) within the object. Passed
directly to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{host}{\code{character(1)} with the host running the database. Passed
directly to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{port}{\code{integer(1)} with the port number (optional). Passed directly to
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{data}{For \code{backendInitialize()}: optional \code{DataFrame} with the full
spectra data that should be inserted into a (new) \code{MsBackendSql}
database. If provided, it is assumed that the provided database
connection information if for a (writeable) empty database into which
\code{data} should be inserted. \code{data} could be the output of \code{spectraData}
from another backend.}

\item{...}{ignored.}
}
\description{
The \code{MsBackendOfflineSql} backend extends the \code{\link[=MsBackendSql]{MsBackendSql()}} backend
directly and inherits thus all of its functions as well as properties.
The only difference between the two backend is that \code{MsBackendSql} keeps
an active connection to the SQL database inside the object while the
\code{MsBackendOfflineSql} backends reconnects to the SQL database for each
query. While the performance of the latter is slightly lower (due to the
need to connect/disconnect to the database for each function call) it can
also be used in a parallel processing environment.
}
\section{Creation of backend objects}{


An empty instance of an \code{MsBackendOfflineSql} class can be created using the
\code{MsBackendOfflineSql()} function. An existing \emph{MsBackendSql} SQL database
can be loaded with the \code{backendInitialize()} function. This function takes
parameters \code{drv}, \code{dbname}, \code{user}, \code{password}, \code{host} and \code{port}, all
parameters that are passed to the \code{dbConnect()} function to connect to
the (\strong{existing}) SQL database.

See \code{\link[=MsBackendSql]{MsBackendSql()}} for information on how to create a \emph{MsBackend} SQL
database.
}

\author{
Johannes Rainer
}
