% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendRawFileReader-functions.R,
%   R/MsBackendRawFileReader.R
\name{MsBackendRawFileReader}
\alias{MsBackendRawFileReader}
\alias{filterScan,MsBackendRawFileReader-method}
\alias{scanType,MsBackendRawFileReader-method}
\alias{scanIndex,MsBackendRawFileReader-method}
\title{MsBackendRawFileReader}
\usage{
MsBackendRawFileReader()

\S4method{filterScan}{MsBackendRawFileReader}(object, filter = character(), ...)

\S4method{scanType}{MsBackendRawFileReader}(object, ...)

\S4method{scanIndex}{MsBackendRawFileReader}(object, ...)
}
\arguments{
\item{object}{MsBackendRawFileReader object}

\item{filter}{filter string}

\item{...}{Arguments to be passed to methods.}
}
\value{
a MsBackendRawFileReader object.

a character vector of scan types.

a character vector of scan index.
}
\description{
MsBackendRawFileReader
}
\examples{
beRaw <- Spectra::backendInitialize(MsBackendRawFileReader::MsBackendRawFileReader(),
  files = rawrr::sampleFilePath())
beRaw |> MsBackendRawFileReader::filterScan('Ms')
beRaw <- Spectra::backendInitialize(MsBackendRawFileReader::MsBackendRawFileReader(),
  files = rawrr::sampleFilePath())
scanType(beRaw) |> head()
beRaw <- Spectra::backendInitialize(MsBackendRawFileReader::MsBackendRawFileReader(),
  files = rawrr::sampleFilePath())
scanIndex(beRaw) |> head()
}
