% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendMassbankSql-functions.R,
%   R/MsBackendMassbankSql.R
\name{MsBackendMassbankSql}
\alias{MsBackendMassbankSql}
\alias{MsBackendMassbankSql-class}
\alias{compounds}
\alias{backendInitialize,MsBackendMassbankSql-method}
\alias{peaksData,MsBackendMassbankSql-method}
\alias{dataStorage,MsBackendMassbankSql-method}
\alias{intensity<-,MsBackendMassbankSql-method}
\alias{mz<-,MsBackendMassbankSql-method}
\alias{reset,MsBackendMassbankSql-method}
\alias{spectraData,MsBackendMassbankSql-method}
\alias{spectraNames,MsBackendMassbankSql-method}
\alias{spectraNames<-,MsBackendMassbankSql-method}
\alias{tic,MsBackendMassbankSql-method}
\alias{[,MsBackendMassbankSql-method}
\alias{extractByIndex,MsBackendMassbankSql,ANY-method}
\alias{compounds,Spectra-method}
\alias{compounds,MsBackendMassbankSql-method}
\alias{$<-,MsBackendMassbankSql-method}
\alias{precScanNum,MsBackendMassbankSql-method}
\alias{backendBpparam,MsBackendMassbankSql-method}
\title{MS backend accessing the MassBank MySQL database}
\usage{
MsBackendMassbankSql()

\S4method{backendInitialize}{MsBackendMassbankSql}(object, dbcon, ...)

\S4method{peaksData}{MsBackendMassbankSql}(object, columns = peaksVariables(object))

\S4method{dataStorage}{MsBackendMassbankSql}(object)

\S4method{intensity}{MsBackendMassbankSql}(object) <- value

\S4method{mz}{MsBackendMassbankSql}(object) <- value

\S4method{reset}{MsBackendMassbankSql}(object)

\S4method{spectraData}{MsBackendMassbankSql}(object, columns = spectraVariables(object))

\S4method{spectraNames}{MsBackendMassbankSql}(object)

\S4method{spectraNames}{MsBackendMassbankSql}(object) <- value

\S4method{tic}{MsBackendMassbankSql}(object, initial = TRUE)

\S4method{[}{MsBackendMassbankSql}(x, i, j, ..., drop = FALSE)

\S4method{extractByIndex}{MsBackendMassbankSql,ANY}(object, i)

\S4method{compounds}{Spectra}(object, ...)

\S4method{compounds}{MsBackendMassbankSql}(object, ...)

\S4method{$}{MsBackendMassbankSql}(x, name) <- value

\S4method{precScanNum}{MsBackendMassbankSql}(object)

\S4method{backendBpparam}{MsBackendMassbankSql}(object, BPPARAM = bpparam())
}
\arguments{
\item{object}{Object extending \code{MsBackendMassbankSql}.}

\item{dbcon}{For \verb{backendInitialize,MsBackendMassbankSql}: SQL database
connection to the MassBank (MariaDb) database.}

\item{...}{Additional arguments.}

\item{columns}{For \code{spectraData} accessor: optional \code{character} with column
names (spectra variables) that should be included in the
returned \code{DataFrame}. By default, all columns are returned.
For \code{peaksData} accessor: optional \code{character} with requested columns in
the individual \code{matrix} of the returned \code{list}. Use
\code{peaksVariables(object)} for supported columns.}

\item{value}{replacement value for \verb{<-} methods. See individual
method description or expected data type.}

\item{initial}{For \code{tic}: \code{logical(1)} whether the initially
reported total ion current should be reported, or whether the
total ion current should be (re)calculated on the actual data
(\code{initial = FALSE}).}

\item{x}{Object extending \code{MsBackendMassbankSql}.}

\item{i}{For \code{[}: \code{integer}, \code{logical} or \code{character} to subset the object.}

\item{j}{For \code{[}: not supported.}

\item{drop}{For \code{[}: not considered.}

\item{name}{name of the variable to replace for \verb{<-} methods. See individual
method description or expected data type.}

\item{BPPARAM}{for \code{backendBpparam}: \code{BiocParallel} parallel processing
setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more information.}

\item{spectraVariables}{For \code{selectSpectraVariables}: \code{character} with the
names of the spectra variables to which the backend should be subsetted.}
}
\value{
See documentation of respective function.
}
\description{
The \code{MsBackendMassbankSql} provides access to mass spectrometry data from
\href{https://massbank.eu/MassBank/}{MassBank} by directly accessing its
MySQL/MariaDb database. In addition it supports adding new spectra variables
or \emph{locally} changing spectra variables provided by MassBank (without
changing the original values in the database).

Note that \code{MsBackendMassbankSql} requires a local installation of the
MassBank database since direct database access is not supported for the
\emph{main} MassBank instance.

Also, some of the fields in the MassBank database are not directly compatible
with \code{Spectra}, such as the \emph{collision energy} which is not available as a
numeric value. The collision energy as available in MassBank is reported as
spectra variable \code{"collision_energy_text"}. Also, precursor m/z values
reported for some spectra can not be converted to a \code{numeric} and hence \code{NA}
is reported with the spectra variable \code{precursorMz} for these spectra. The
variable \code{"precursor_mz_text"} can be used to get the \emph{original} precursor
m/z reported in MassBank.

Finally, \code{MsBackendMassbankSql} does \strong{not support} parallel processing
because the database connection stored within the object can not be
shared acrcoss parallel processes. All functions on \code{Spectra} objects
with a \code{MsBackendMassbankSql} will (silently) disable parallel processing
even if the user provides a dedicated parallel processing setup with
the \code{BPPARAM} parameter.
}
\section{Supported Backend functions}{


The following functions are supported by the \code{MsBackendMassbankSql}.
\itemize{
\item \code{[}: subset the backend. Only subsetting by element (\emph{row}/\code{i}) is
allowed
\item \code{$}, \verb{$<-}: access or set/add a single spectrum variable (column) in the
backend.
\item \code{acquisitionNum}: returns the acquisition number of each
spectrum. Returns an \code{integer} of length equal to the number of
spectra (with \code{NA_integer_} if not available).
\item \code{peaksData} returns a \code{list} with the spectras' peak data. The length of
the list is equal to the number of spectra in \code{object}. Each element of
the list is a \code{matrix} with columns \code{"mz"} and \code{"intensity"}. For an empty
spectrum, a \code{matrix} with 0 rows and two columns (named \code{mz} and
\code{intensity}) is returned. Parameter \code{columns} allows to select which peaks
variables to return, but supports currently only \code{"mz"} and \code{"intensity"}.
\item \code{backendBpparam}: whether the backend supports parallel processing. Takes
a \code{MsBackendMassbankSql} and a parallel processing setup (see
\code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for details) as input and \strong{always} returns a
\code{\link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam()}}. This function can be used to test whether
a provided parallel processing setup is supported by the backend and
returns the supported setup.
\item \code{backendInitialize}: initialises the backend by retrieving the IDs of all
spectra in the database. Parameter \code{dbcon} with the connection to the
MassBank MySQL database is required.
\item \code{dataOrigin}: gets a \code{character} of length equal to the number of spectra
in \code{object} with the \emph{data origin} of each spectrum. This could e.g. be
the mzML file from which the data was read.
\item \code{dataStorage}: returns \code{"<MassBank>"} for all spectra.
\item \code{centroided}, \verb{centroided<-}: gets or sets the centroiding
information of the spectra. \code{centroided} returns a \code{logical}
vector of length equal to the number of spectra with \code{TRUE} if a
spectrum is centroided, \code{FALSE} if it is in profile mode and \code{NA}
if it is undefined. See also \code{isCentroided} for estimating from
the spectrum data whether the spectrum is centroided.  \code{value}
for \verb{centroided<-} is either a single \code{logical} or a \code{logical} of
length equal to the number of spectra in \code{object}.
\item \code{collisionEnergy}, \verb{collisionEnergy<-}: gets or sets the
collision energy for all spectra in \code{object}. \code{collisionEnergy}
returns a \code{numeric} with length equal to the number of spectra
(\code{NA_real_} if not present/defined), \verb{collisionEnergy<-} takes a
\code{numeric} of length equal to the number of spectra in \code{object}. Note that
the collision energy description from MassBank are provided as spectra
variable \code{"collisionEnergyText"}.
\item \code{intensity}: gets the intensity values from the spectra. Returns
a \code{\link[IRanges:AtomicList-class]{IRanges::NumericList()}} of \code{numeric} vectors (intensity values for each
spectrum). The length of the \code{list} is equal to the number of
\code{spectra} in \code{object}.
\item \code{ionCount}: returns a \code{numeric} with the sum of intensities for
each spectrum. If the spectrum is empty (see \code{isEmpty}),
\code{NA_real_} is returned.
\item \code{isCentroided}: a heuristic approach assessing if the spectra in
\code{object} are in profile or centroided mode. The function takes
the \code{qtl} th quantile top peaks, then calculates the difference
between adjacent m/z value and returns \code{TRUE} if the first
quartile is greater than \code{k}. (See \code{Spectra:::.isCentroided} for
the code.)
\item \code{isEmpty}: checks whether a spectrum in \code{object} is empty
(i.e. does not contain any peaks). Returns a \code{logical} vector of
length equal number of spectra.
\item \code{isolationWindowLowerMz}, \verb{isolationWindowLowerMz<-}: gets or sets the
lower m/z boundary of the isolation window.
\item \code{isolationWindowTargetMz}, \verb{isolationWindowTargetMz<-}: gets or sets the
target m/z of the isolation window.
\item \code{isolationWindowUpperMz}, \verb{isolationWindowUpperMz<-}: gets or sets the
upper m/z boundary of the isolation window.
\item \code{isReadOnly}: returns a \code{logical(1)} whether the backend is \emph{read
only} or does allow also to write/update data.
\item \code{length}: returns the number of spectra in the object.
\item \code{lengths}: gets the number of peaks (m/z-intensity values) per
spectrum.  Returns an \code{integer} vector (length equal to the
number of spectra). For empty spectra, \code{0} is returned.
\item \code{msLevel}: gets the spectra's MS level. Returns an \code{integer}
vector (of length equal to the number of spectra) with the MS
level for each spectrum (or \code{NA_integer_} if not available).
\item \code{mz}: gets the mass-to-charge ratios (m/z) from the
spectra. Returns a \code{\link[IRanges:AtomicList-class]{IRanges::NumericList()}} or length equal to the
number of spectra, each element a \code{numeric} vector with the m/z values of
one spectrum.
\item \code{polarity}, \verb{polarity<-}: gets or sets the polarity for each
spectrum.  \code{polarity} returns an \code{integer} vector (length equal
to the number of spectra), with \code{0} and \code{1} representing negative
and positive polarities, respectively. \verb{polarity<-} expects an
integer vector of length 1 or equal to the number of spectra.
\item \code{precursorCharge}, \code{precursorIntensity}, \code{precursorMz},
\code{precScanNum}, \code{precAcquisitionNum}: get the charge (\code{integer}),
intensity (\code{numeric}), m/z (\code{numeric}), scan index (\code{integer})
and acquisition number (\code{interger}) of the precursor for MS level
2 and above spectra from the object. Returns a vector of length equal to
the number of spectra in \code{object}. \code{NA} are reported for MS1
spectra of if no precursor information is available.
\item \code{reset}: restores the backend to its original state, i.e. deletes all
locally modified data and reinitializes the backend to the full data
available in the database.
\item \code{rtime}, \verb{rtime<-}: gets or sets the retention times for each
spectrum (in seconds). \code{rtime} returns a \code{numeric} vector (length equal to
the number of spectra) with the retention time for each spectrum.
\verb{rtime<-} expects a numeric vector with length equal to the
number of spectra.
\item \code{scanIndex}: returns an \code{integer} vector with the \emph{scan index}
for each spectrum. This represents the relative index of the
spectrum within each file. Note that this can be different to the
\code{acquisitionNum} of the spectrum which is the index of the
spectrum as reported in the mzML file.
\item \code{selectSpectraVariables}: reduces the information within the backend to
the selected spectra variables.
\item \code{smoothed},\verb{smoothed<-}: gets or sets whether a spectrum is
\emph{smoothed}. \code{smoothed} returns a \code{logical} vector of length equal
to the number of spectra. \verb{smoothed<-} takes a \code{logical} vector
of length 1 or equal to the number of spectra in \code{object}.
\item \code{spectraData}: gets general spectrum metadata (annotation, also called
header).  \code{spectraData} returns a \code{DataFrame}. Note that replacing the
spectra data with \verb{spectraData<-} is not supported.
\item \code{spectraNames}: returns a \code{character} vector with the names of
the spectra in \code{object}.
\item \code{spectraVariables}: returns a \code{character} vector with the
available spectra variables (columns, fields or attributes)
available in \code{object}. This should return \strong{all} spectra variables which
are present in \code{object}, also \code{"mz"} and \code{"intensity"} (which are by
default not returned by the \verb{spectraVariables,Spectra} method).
\item \code{tic}: gets the total ion current/count (sum of signal of a
spectrum) for all spectra in \code{object}. By default, the value
reported in the original raw data file is returned. For an empty
spectrum, \code{NA_real_} is returned.
}
}

\section{Not supported Backend functions}{


The following functions are not supported by the \code{MsBackendMassbankSql} since
the original data can not be changed.

\code{backendMerge}, \code{export}, \code{filterDataStorage}, \code{filterPrecursorScan},
\verb{peaksData<-}, \code{filterAcquisitionNum}, \verb{intensity<-}, \verb{mz<-}, \code{precScanNum},
\verb{spectraData<-}, \verb{spectraNames<-}.
}

\section{Retrieving compound annotations for spectra}{


While compound annotations are also provided \emph{via} the \code{spectraVariables} of
the backend, it would also be possible to use the \code{compounds} function on
a \code{Spectra} object (that uses a \code{MsBackendMassbankSql} backend) to retrieve
compound annotations for the specific spectra.
}

\examples{

## Create a connection to a database with MassBank data - in the present
## example we connect to a tiny SQLite database bundled in this package
## as public access to the MassBank MySQL is not (yet) supported. See the
## vignette for more information on how to install MassBank locally and
## enable MySQL database connections
library(RSQLite)
con <- dbConnect(SQLite(), system.file("sql", "minimassbank.sqlite",
    package = "MsBackendMassbank"))

## Given that we have the connection to a MassBank databas we can
## initialize the backend:
be <- backendInitialize(MsBackendMassbankSql(), dbcon = con)
be

## Access MS level
msLevel(be)
be$msLevel

## Access m/z values
be$mz

## Access the full spectra data (including m/z and intensity values)
spectraData(be)

## Add a new spectra variable
be$new_variable <- "b"
be$new_variable

## Subset the backend
be_sub <- be[c(3, 1)]

spectraNames(be)
spectraNames(be_sub)
}
\author{
Johannes Rainer
}
