% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_seqs.R
\name{trim_seqs}
\alias{trim_seqs}
\title{Trim sequences to a specified width around the summit}
\usage{
trim_seqs(peaks, peak_width, genome_build, respect_bounds = TRUE)
}
\arguments{
\item{peaks}{A GRanges object created using
\code{\link[=read_peak_file]{read_peak_file()}}.}

\item{peak_width}{Total expected width of the peak.}

\item{genome_build}{The genome build that the peak sequences should be
derived from.}

\item{respect_bounds}{Logical indicating whether the peak width should be
respected when trimming sequences. (default = TRUE) If \code{TRUE}, the
trimmed sequences will not extend beyond the peak boundaries.}
}
\value{
A GRanges object with the trimmed sequences. The sequences are
guaranteed to not exceed the \code{peak width + 1} (peak width + the summit
base).
}
\description{
Trim sequences to a specified width around the summit
}
\examples{
data("CTCF_TIP_peaks", package = "MotifPeeker")
peaks <- CTCF_TIP_peaks
genome_build <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38

trimmed_seqs <- MotifPeeker:::trim_seqs(peaks, peak_width = 100,
                         genome_build = genome_build)
summary(GenomicRanges::width(trimmed_seqs))

}
\keyword{internal}
