% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summit_to_motif.R
\name{summit_to_motif}
\alias{summit_to_motif}
\title{Calculate the distance between peak summits and motifs}
\usage{
summit_to_motif(
  peak_input,
  motif,
  fp_rate = 0.05,
  genome_build,
  out_dir = tempdir(),
  meme_path = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{peak_input}{Either a path to the narrowPeak file or a GRanges peak
object generated by \code{read_peak_file()}.}

\item{motif}{An object of class \code{universalmotif}.}

\item{fp_rate}{The desired false-positive rate. A p-value threshold will be
selected based on this value. The default false-positive rate is
0.05.}

\item{genome_build}{The genome build that the peak sequences should be
derived from.}

\item{out_dir}{Location to save the 0-order background file. By default, the
background file will be written to a temporary directory.}

\item{meme_path}{path to "meme/bin/" (default: \code{NULL}). Will use default
search behavior as described in \code{check_meme_install()} if unset.}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}

\item{...}{
  Arguments passed on to \code{\link[memes:runFimo]{memes::runFimo}}
  \describe{
    \item{\code{parse_genomic_coord}}{\code{logical(1)} whether to parse genomic position
from fasta headers. Fasta headers must be UCSC format positions (ie
"chr:start-end"), but base 1 indexed (GRanges format). If names of fasta
entries are genomic coordinates and parse_genomic_coord == TRUE, results
will contain genomic coordinates of motif matches, otherwise FIMO will return
relative coordinates (i.e. positions from 1 to length of the fasta entry).}
    \item{\code{skip_matched_sequence}}{\code{logical(1)} whether or not to include the DNA
sequence of the match. Default: \code{FALSE}. Note: jobs will complete faster if
set to \code{TRUE}. \code{add_sequence()} can be used to lookup the sequence after data import if
\code{parse_genomic_coord} is \code{TRUE}, so setting this flag is not strictly needed.}
    \item{\code{max_strand}}{if match is found on both strands, only report strand with
best match (default: TRUE).}
    \item{\code{text}}{\code{logical(1)} (default: \code{TRUE}). No output files will be created
on the filesystem. The results are unsorted and no q-values are computed.
This setting allows fast searches on very large inputs. When set to \code{FALSE}
FIMO will discard 50\% of the lower significance matches if >100,000 matches are
detected. \code{text = FALSE} will also incur a performance penalty because it
must first read a file to disk, then read it into memory. For these reasons,
I suggest keeping \code{text = TRUE}.}
    \item{\code{silent}}{\code{logical(1)} whether to suppress stdout/stderr printing to
console (default: TRUE). If the command is failing or giving unexpected
output, setting \code{silent = FALSE} can aid troubleshooting.}
  }}
}
\value{
A list containing an expanded GRanges peak object with metadata
columns relating to motif positions along with a vector of summit-to-motif
distances for each valid peak.
}
\description{
\code{summit_to_motif()} calculates the distance between each motif and its
nearest peak summit. \code{runFimo} from the \code{memes} package is used to
recover the locations of each motif.
}
\details{
To calculate the p-value threshold for a desired false-positive rate, we use
the approximate formula:
\deqn{p \approx \frac{fp\_rate}{2 \times \text{average peak width}}}
(Dervied from
\href{https://meme-suite.org/meme/doc/fimo-tutorial.html}{FIMO documentation})
}
\examples{
if (memes::meme_is_installed()) {
data("CTCF_TIP_peaks", package = "MotifPeeker")
data("motif_MA1102.3", package = "MotifPeeker")

res <- summit_to_motif(
    peak_input = CTCF_TIP_peaks,
    motif = motif_MA1102.3,
    fp_rate = 5e-02,
    genome_build = BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
)
print(res)
}

}
\seealso{
\code{\link[memes]{runAme}}
}
