% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_motif_file.R
\name{read_motif_file}
\alias{read_motif_file}
\title{Read a motif file}
\usage{
read_motif_file(motif_file, file_format = "auto", verbose = FALSE)
}
\arguments{
\item{motif_file}{Path to a motif file or a
\code{\link[universalmotif]{universalmotif-class}} object.}

\item{file_format}{Character string specifying the format of the motif file.
The options are "homer", "jaspar", "meme", "transfac" and "uniprobe"}

\item{verbose}{A logical indicating whether to print messages.}
}
\value{
A \code{universalmotif} motif object.
}
\description{
\code{read_motif_file()} reads a motif file and converts to a PWM. The
function supports multiple motif formats, including "homer", "jaspar",
"meme", "transfac" and "uniprobe".
}
\examples{
motif_file <- system.file("extdata",
                          "motif_MA1930.2.jaspar",
                          package = "MotifPeeker")
res <- read_motif_file(motif_file = motif_file,
                       file_format = "jaspar")
print(res)

}
