% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_denovo_sections.R
\name{print_denovo_sections}
\alias{print_denovo_sections}
\title{Print denovo motif enrichment \code{\link[DT]{datatable}} and download
buttons for related files.}
\usage{
print_denovo_sections(
  motif_list,
  similar_motifs,
  segregated_peaks,
  indices,
  jaspar_link = FALSE,
  download_buttons = NULL
)
}
\arguments{
\item{motif_list}{A list of motifs discovered by
\code{\link{find_motifs}}, for one comparison pair.}

\item{similar_motifs}{A list of similar motifs discovered using
\code{\link{motif_similarity}}, for one comparison pair.}

\item{segregated_peaks}{A list of peaks segregated by common and unique
groups, for one comparison pair.}

\item{indices}{A list of indices to print the \code{datatable} and download
buttons for.}

\item{jaspar_link}{A logical indicating whether to include a link to the
JASPAR database for the motifs. Only set to \code{TRUE} if the motifs are
in JASPAR format (example: "MA1930.1").}

\item{download_buttons}{Embed download buttons generated using
\code{\link{get_download_buttons}}. If set to \code{NULL}, no download
buttons will be added.}
}
\value{
Null
}
\description{
Print denovo motif enrichment \code{\link[DT]{datatable}} and download
buttons for related files.
}
\seealso{
Other datatable functions: 
\code{\link{dt_enrichment_individual}()}
}
\concept{datatable functions}
\keyword{internal}
