% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment.R
\name{motif_enrichment}
\alias{motif_enrichment}
\title{Calculate motif enrichment in a set of sequences}
\usage{
motif_enrichment(
  peak_input,
  motif,
  genome_build,
  out_dir = tempdir(),
  verbose = FALSE,
  meme_path = NULL,
  ...
)
}
\arguments{
\item{peak_input}{Either a path to the narrowPeak file or a GRanges peak
object generated by \code{read_peak_file()}.}

\item{motif}{An object of class \code{universalmotif}.}

\item{genome_build}{The genome build that the peak sequences should be
derived from.}

\item{out_dir}{Location to save the 0-order background file along with the
AME output files.}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}

\item{meme_path}{path to "meme/bin/" (default: \code{NULL}). Will use default
search behavior as described in \code{check_meme_install()} if unset.}

\item{...}{
  Arguments passed on to \code{\link[memes:runAme]{memes::runAme}}
  \describe{
    \item{\code{method}}{default: fisher (allowed values: fisher, ranksum, pearson, spearman, 3dmhg, 4dmhg)}
    \item{\code{sequences}}{\code{logical(1)} add results from \code{sequences.tsv} to \code{sequences}
list column to returned data.frame. Valid only if method = "fisher". See
\href{http://alternate.meme-suite.org/doc/ame-output-format.html}{AME outputs}
webpage for more information (Default: FALSE).}
    \item{\code{silent}}{whether to suppress stdout (default: TRUE), useful for debugging.}
  }}
}
\value{
A list containing a AME results data frame and a numeric referring
to the proportion of peaks with a motif.
}
\description{
\code{motif_enrichment()} calculates motif enrichment relative to a set of
background sequences using Analysis of Motif Enrichment (AME) from
\link[memes]{memes-package}.
}
\examples{
if (memes::meme_is_installed()) {
    data("CTCF_TIP_peaks", package = "MotifPeeker")
    data("motif_MA1102.3", package = "MotifPeeker")

    res <- motif_enrichment(
        peak_input = CTCF_TIP_peaks,
        motif = motif_MA1102.3,
        genome_build =
            BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38,
        
    )
    print(res)
}

}
\seealso{
\code{\link[memes]{runAme}}
}
