% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_motifs.R
\name{find_motifs}
\alias{find_motifs}
\title{Find similar motifs}
\usage{
find_motifs(
  streme_out,
  motif_db,
  out_dir = tempdir(),
  meme_path = NULL,
  BPPARAM = BiocParallel::bpparam(),
  verbose = FALSE,
  debug = FALSE,
  ...
)
}
\arguments{
\item{streme_out}{Output from \code{\link{denovo_motifs}}.}

\item{motif_db}{Path to \code{.meme} format file to use as reference
database, or a list of \code{\link[universalmotif]{universalmotif-class}}
objects. (optional) Results from de-novo motif discovery are searched against
this database to find similar motifs. If not provided, JASPAR CORE database
will be used. \strong{NOTE}: p-value estimates are inaccurate when the
database has fewer than 50 entries.}

\item{out_dir}{A \code{character} vector of output directory to save STREME
results to. (default = \code{tempdir()})}

\item{meme_path}{path to "meme/bin/" (default: \code{NULL}). Will use default
search behavior as described in \code{check_meme_install()} if unset.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam-class}} object
specifying run parameters. (default = bpparam())}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}

\item{debug}{A logical indicating whether to print debug messages while
running the function. (default = FALSE)}

\item{...}{Additional arguments to pass to \code{TOMTOM}. For more
information, refer to the official MEME Suite documentation on
\href{https://meme-suite.org/meme/doc/tomtom.html}{TOMTOM}.}
}
\value{
data.frame of match results. Contains \code{best_match_motif} column of
\code{universalmotif} objects with the matched PWM from the database, a series
of \verb{best_match_*} columns describing the TomTom results of the match, and a
\code{tomtom} list column storing the ranked list of possible matches to each
motif. If a universalmotif data.frame is used as input, these columns are
appended to the data.frame. If no matches are returned, \code{tomtom} and
\code{best_match_motif} columns will be set to \code{NA} and a message indicating
this will print.
}
\description{
Search through provided motif database to find similar motifs to the input.
Light wrapper around \code{TOMTOM} from MEME Suite.
}
\examples{
if (memes::meme_is_installed()) {
    data("CTCF_TIP_peaks", package = "MotifPeeker")
    
    if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly = TRUE)) {
        genome_build <-
            BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
   
        res <- denovo_motifs(list(CTCF_TIP_peaks),
                        trim_seq_width = 50,
                        genome_build = genome_build,
                        discover_motifs_count = 1,
                        filter_n = 10,
                        out_dir = tempdir())
        res2 <- find_motifs(res, motif_db = get_JASPARCORE(),
                            out_dir = tempdir())
        print(res2)
    }
}

}
