% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input.R
\name{check_input}
\alias{check_input}
\title{Check for input validity and pass to appropriate function}
\usage{
check_input(x, type, FUN, inverse = FALSE, ...)
}
\arguments{
\item{x}{The input to check.}

\item{type}{The type of input to check for. Supported types are:
\itemize{
 \item \code{jaspar_id}: JASPAR identifier.
 \item \code{motif}: `universalmotif` motif object.
 \item \code{encode_id}: ENCODE identifier.
}}

\item{FUN}{The function to pass the input to.}

\item{inverse}{Logical indicating whether to return the input if it is
invalid for the specified `type`.}

\item{...}{Additional arguments to pass to the `FUN` function.}
}
\value{
`x` if the input is invalid for the specified `type`, or else the
output of the `FUN` function. If `inverse = TRUE`, the function returns the
output of the `FUN` function if the input is valid, or else `x`.
}
\description{
Check for input validity and pass to appropriate function
}
\keyword{internal}
