% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{findMotifs}
\alias{findMotifs}
\title{Find motif instances with a certain mismatch number}
\usage{
findMotifs(
  motif,
  mismatchNumber,
  genome,
  genomeBuild,
  DB = "UCSC",
  mainCHRs = TRUE,
  firstCHR = FALSE,
  MotifLocationName = "Motif_Locations",
  limitedRegion = NA
)
}
\arguments{
\item{motif}{motif characters in nucleotide IUPAC format}

\item{mismatchNumber}{Number of mismatch allowed to match with motif}

\item{genome}{The genome name such as "Hsapiens", "Mmusculus",
"Dmelanogaster"}

\item{genomeBuild}{The genome build such as "hg38", "hg19", "mm10", "dm3"}

\item{DB}{The database of genome build. default: "UCSC"}

\item{mainCHRs}{If true only the major chromosome are considered, if FALSE
Random, Uncharacterised, and Mithocondrial chromosomes are also considered}

\item{firstCHR}{If true only Chr1 is used to find motifs. Default is FALSE}

\item{MotifLocationName}{The name of the file of the motif locations}

\item{limitedRegion}{If specified the motifs are detected in the provided
granges}
}
\value{
No return value
}
\description{
Find motif instances in a given genome. It gets motif strings
and related allowed mismatchnumbers and returns genomewide motif instances.

The genome and build information should be provided and relevant
 BS genomes packages such as BSgenome.Mmusculus.UCSC.mm10 or
  BSgenome.Hsapiens.UCSC.hg38 must be installed for the used genome and
  builds.
}
