% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataTCGA.R
\name{getDataTCGA}
\alias{getDataTCGA}
\title{getDataTCGA}
\usage{
getDataTCGA(
  cancerType,
  dataType,
  directory,
  cor.cut = 0.6,
  qnt.cut = 0.25,
  nSample,
  stage = "ALL",
  subtype = 0,
  samples = NULL
)
}
\arguments{
\item{cancerType}{select cancer type for which analysis should be run. panCancer
for all available cancer types in TCGA. Defaults to panCancer}

\item{dataType}{is dataType such as gene expression, cnv, methylation etc.}

\item{directory}{Directory/Folder where the data was downloaded. Default: GDCdata}

\item{cor.cut}{cor.cut}

\item{qnt.cut}{qnt.cut}

\item{nSample}{nSample}

\item{stage}{stage}

\item{subtype}{subtype}

\item{samples}{samples}
}
\value{
returns filtered TCGA data
}
\description{
This function retrieves and prepares TCGA data
}
\examples{
\dontrun{
dataFilt <- getDataTCGA(cancerType = "LUAD",
dataType = "Gene expression", directory = "data", nSample = 4)
}
}
