% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMolecules.R
\name{readMolecules}
\alias{readMolecules}
\title{Read in detected transcripts file/s into a MoleculeExperiment object}
\usage{
readMolecules(
  dataDir,
  pattern = NULL,
  featureCol = NULL,
  xCol = NULL,
  yCol = NULL,
  keepCols = "essential",
  moleculesAssay = NULL,
  scaleFactorVector = 1
)
}
\arguments{
\item{dataDir}{Character string specifying the directory with the file/s
containing detected transcripts for different runs/samples.}

\item{pattern}{Character string specifying the pattern with which to find
the transcripts files. For example, in Xenium data, the pattern would be
"transcripts.csv". In contrast, in Cosmx data, the pattern would be
"tx_file".}

\item{featureCol}{Character string specifying the name of the column with
feature names. For example, "feature_name" in xenium transcripts.csv files.}

\item{xCol}{Character string specifying the name of the column with the x
locations of the transcripts.}

\item{yCol}{Character string specifying the name of the column with the y
locations of the transcripts.}

\item{keepCols}{Vector of characters specifying the columns of interest from
the transcripts file. "essential" selects columns with gene names, x and y
locations. "all" will select all columns. Alternatively, specific colums
of interest can be selected by specifying them as characters in a vector.
Note that this personalised vector needs to contain the essential columns.}

\item{moleculesAssay}{Character string specifying the name of the list in
which the transcript information is going to be stored in the molecules slot.
The default name is "detected", as we envision that a MoleculeExperiment will
usually be created with raw detected transcript information.}

\item{scaleFactorVector}{Vector containing the scale factor/s with which to
change the coordinate data from pixel to micron. It can be either a single
integer, or multiple scale factors for the different samples. The default
value is 1.}
}
\value{
A simple MoleculeExperiment object with a filled molecules slot.
}
\description{
A function to standardise transcripts.csv files across different molecule-
based ST technologies, and store them into an ME object.
It is technology agnostic, so it is accompanied with wrappers for the
specific technologies (e.g., see readXenium).
}
\examples{
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")
simple_me <- readMolecules(repoDir,
    pattern = "transcripts.csv",
    featureCol = "feature_name",
    xCol = "x_location",
    yCol = "y_location",
    keepCols = "essential"
)
simple_me
}
