% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bufferBoundaries.R
\name{bufferBoundaries}
\alias{bufferBoundaries}
\title{Create a new boundaries assay with buffers}
\usage{
bufferBoundaries(me, assayName = "cell", ...)
}
\arguments{
\item{me}{A MoleculeExperiment object.}

\item{assayName}{Character string (default "cell") specifying the existing
boundaries assay that should have buffer added.}

\item{...}{Arguments that pass to internal functions. The most relevant
parameter is buffer (default 0).}
}
\value{
A boundaries assay with essential columns and vertices with added
buffer.
}
\description{
This function takes in an existing MoleculeExperiment object and generates
a new boundaries assay with added buffers. This can be useful for
visualisation and for countMolecules.
}
\examples{
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")
me <- readXenium(repoDir,
  keepCols = "essential"
)
MoleculeExperiment::boundaries(me, "cell_buffer") <- bufferBoundaries(
  me,
  assayName = "cell", buffer = 1
)

library(ggplot2)
ggplot_me() +
  geom_polygon_me(me, assayName = "cell", fill = "grey") +
  geom_polygon_me(me, assayName = "cell_buffer", fill = NA, colour = "red") +
  geom_point_me(me) +
  coord_cartesian(
    xlim = c(4900, 4919.98),
    ylim = c(6400.02, 6420)
  )
}
