% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-ModStringSet.R
\docType{class}
\name{ModStringSet}
\alias{ModStringSet}
\alias{ModDNAStringSet}
\alias{ModRNAStringSet}
\alias{ModStringSet,ANY-method}
\alias{ModStringSet,AsIs-method}
\alias{ModStringSet,character-method}
\alias{ModStringSet,factor-method}
\alias{ModStringSet,ModString-method}
\alias{ModStringSet,ModStringSet-method}
\alias{ModStringSet,list-method}
\alias{ModStringSet,missing-method}
\alias{as.character,ModStringSet-method}
\alias{show,ModStringSet-method}
\alias{==,ModStringSet,ModStringSet-method}
\alias{==,ModStringSet,XStringSet-method}
\alias{==,XStringSet,ModStringSet-method}
\alias{ModDNAStringSet-class}
\alias{ModRNAStringSet-class}
\title{ModStringSet objects}
\usage{
ModDNAStringSet(
  x = character(),
  start = NA,
  end = NA,
  width = NA,
  use.names = TRUE
)

ModRNAStringSet(
  x = character(),
  start = NA,
  end = NA,
  width = NA,
  use.names = TRUE
)
}
\arguments{
\item{x}{Either a character vector (with no NAs), or an ModString, 
ModStringSet or ModStringViews object.}

\item{start, end, width}{Either NA, a single integer, or an integer vector of 
the same length as x specifying how x should be "narrowed" (see ?narrow for 
the details).}

\item{use.names}{TRUE or FALSE. Should names be preserved?}
}
\value{
a \code{ModStringSet} object.
}
\description{
The \code{ModStringSet} class is a container for storing a set of 
\code{\link{ModString}} objects. It follows the same principles as the 
other \code{\link[Biostrings:XStringSet-class]{XStringSet}} objects.

As usual the \code{ModStringSet} containers derive directly from the 
\code{\link[Biostrings:XStringSet-class]{XStringSet}} virtual class.

The \code{ModStringSet} class is in itself a virtual class with two types of
derivates:
\itemize{
 \item \code{ModDNAStringSet} 
 \item \code{ModRNAStringSet} 
}
Each class can only be converted to its parent \code{DNAStringSet} or 
\code{RNAStringSet}. The modified nucleotides will be converted to their
original nucleotides.

Please note, that due to encoding issues not all modifications can be
instanciated directly from the console. The vignette contains
a comphrensive explanation and examples for working around the problem.
}
\examples{
# Constructing ModDNAStringSet containing an m6A
m1 <- ModDNAStringSet(c("AGCT`","AGCT`"))
m1

# converting to DNAStringSet

# Constructing ModRNAStringSet containing an m6A
m2 <- ModRNAStringSet(c("AGCU`","AGCU`"))
m2
}
