% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-MinDistPosterior.R
\name{denovoHemizygous}
\alias{denovoHemizygous}
\alias{denovoHomozygous}
\alias{denovo}
\alias{denovoDuplication}
\alias{denovoHemizygous,MinDistPosterior-method}
\alias{denovoHomozygous,MinDistPosterior-method}
\alias{denovoDuplication,MinDistPosterior-method}
\alias{denovo,MinDistPosterior-method}
\title{Filter the genomic intervals for denovo copy number states}
\usage{
denovoHemizygous(object, filters = FilterParamMD(state = "221"))

denovoHomozygous(object, filters = FilterParamMD(state = "220"))

denovo(object, filters = FilterParamMD(state = c("220", "221", "224")))

denovoDuplication(object, filters = FilterParamMD(state = "224"))

\S4method{denovoHemizygous}{MinDistPosterior}(object, filters = FilterParamMD(state = "221"))

\S4method{denovoHomozygous}{MinDistPosterior}(object, filters = FilterParamMD(state = "220"))

\S4method{denovoDuplication}{MinDistPosterior}(object, filters = FilterParamMD(state = "224"))

\S4method{denovo}{MinDistPosterior}(object, filters = FilterParamMD(state = c("220", "221", "224")))
}
\arguments{
\item{object}{see \code{showMethods(denovo)} for a list of defined methods}

\item{filters}{an object of class \code{FilterParamMD}}
}
\description{
This function filters the genomic intervals for denovo events.
}
\details{
The function \code{denovo} filters genomic intervals for states
'220', '221', and '224', corresponding to denovo homozygous
deletion, denovo hemizygous deletion, and denovo duplication,
respectively.

\code{denovoHemizygous} filters genomic intervals for state '221'.

\code{denovoHomozygous} filters genomic intervals for state '220'
}
\seealso{
FilterParamMD-class
}
