% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R,
%   R/methods-ParentOffspring.R
\docType{class}
\name{ParentOffspring-class}
\alias{ParentOffspring-class}
\alias{offspring}
\alias{mother}
\alias{father}
\alias{ParentOffspring}
\alias{pedigreeName,ParentOffspring-method}
\alias{father,ParentOffspring-method}
\alias{mother,ParentOffspring-method}
\alias{offspring,ParentOffspring-method}
\alias{show,ParentOffspring-method}
\alias{names,ParentOffspring-method}
\title{Object containing the sample identifiers for members in a pedigree}
\usage{
offspring(object)

mother(object)

father(object)

ParentOffspring(
  id = character(),
  father = character(),
  mother = character(),
  offspring = character(),
  parsedPath = character()
)

\S4method{pedigreeName}{ParentOffspring}(object)

\S4method{father}{ParentOffspring}(object)

\S4method{mother}{ParentOffspring}(object)

\S4method{offspring}{ParentOffspring}(object)

\S4method{show}{ParentOffspring}(object)

\S4method{names}{ParentOffspring}(x)
}
\arguments{
\item{object}{a \code{ParentOffspring} object}

\item{id}{length-one character vector providing a family-level id}

\item{father}{length-one character vector providing sample ids for father}

\item{mother}{length-one character vector providing sample ids for mother}

\item{offspring}{character vector providing sample ids for offspring (can have length greater than one if there is more than one offspring)}

\item{parsedPath}{character vector providing path to low-level data}

\item{x}{a \code{ParentOffspring} object}
}
\description{
Container for registering sample identifiers with membership in a
pedigree.  For representing multiple pedigrees, see
\code{\linkS4class{ParentOffspringList}}.

Accessor for the sample identifiers for the members in a
pedigree
}
\section{Slots}{

\describe{
\item{\code{id}}{length-one character vector providing a family-level id}

\item{\code{father}}{length-one character vector providing sample ids for father}

\item{\code{mother}}{length-one character vector providing sample ids for mother}

\item{\code{offspring}}{character vector providing sample ids for offspring (can have length greater than one if there is more than one offspring)}

\item{\code{parsedPath}}{character vector providing path to parsed files of the marker-level summaries}
}}

\examples{
ParentOffspring()
}
\seealso{
ParentOffspringList-class
}
