% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-MinDistExperiment.R
\name{MAP2}
\alias{MAP2}
\alias{MAP2,MinDistExperiment,MinDistGRanges-method}
\alias{MAP2,MinDistExperiment,GRangesList-method}
\alias{MAP2,MinDistExperiment,GRanges-method}
\title{Computes maximum a posteriori estimate for the trio copy number state}
\usage{
MAP2(object, mdgr, param = MinDistParam(), ...)

\S4method{MAP2}{MinDistExperiment,MinDistGRanges}(object, mdgr, param = MinDistParam(), ...)

\S4method{MAP2}{MinDistExperiment,GRangesList}(object, mdgr, param = MinDistParam(), ...)

\S4method{MAP2}{MinDistExperiment,GRanges}(object, mdgr, param = MinDistParam(), ...)
}
\arguments{
\item{object}{An object of class \code{MinDistExperiment}}

\item{mdgr}{An object of class \code{MinDistGRanges}, \code{GRangesList}, or \code{GRanges}.}

\item{param}{An object of class \code{MinDistParam}.}

\item{...}{ignored}
}
\value{
An object of class \code{MinDistPosterior}
}
\description{
Computes maximum a posteriori estimate for the trio copy number state
}
\examples{
  library(oligoClasses)
  library(VanillaICE)
  ## A MinDistExperiment object:
  data(md_exp)
  ## Segmented data
  data(md_gr)
  e_param <- EmissionParam(temper=1, p_outlier=1/100)
  param <- MinDistParam(thin=1L, emission=e_param)
\dontrun{
  md_g <- MAP2(md_exp, md_gr, param)
}
}
