% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FilterParamMD.R
\name{FilterParamMD}
\alias{FilterParamMD}
\title{Parameters for filtering results from the segmentation and copy number inference}
\usage{
FilterParamMD(state = trioStateNames(), seqnames = paste0("chr", 1:22), ...)
}
\arguments{
\item{state}{trio copy number states to select}

\item{seqnames}{chromosome names to select}

\item{...}{additional arguments passed to \code{\link[VanillaICE]{FilterParam-class}}}
}
\description{
A container for criteria used to filter the segmentation results
post-hoc.  Options including filtering on the posterior call, the
posterior probability of the posterior call, the minimum number of
markers spanned by the segment, the minimum width of the segment,
and chromosome.  Convenience functions are available for commonly
used filters.
}
\examples{
library(VanillaICE)
data(md_gr)
data(md_exp)
mdparam <- MinDistParam()
fit <- MAP2(md_exp, md_gr, mdparam)
## return all segments
segs(fit)

## Default filters
param <- FilterParamMD()
param
cnvFilter(fit, param)

param2 <- FilterParamMD(seqnames="chr22", probability=0.9, numberFeatures=10)
cnvFilter(fit, param2)
denovoHemizygous(fit)
}
