% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_utilities.R
\name{split_str_to_list}
\alias{split_str_to_list}
\title{split a dataframe contained one column}
\usage{
split_str_to_list(
  strdataframe,
  prefix = "tax",
  sep = "; ",
  extra = "drop",
  fill = "right",
  ...
)
}
\arguments{
\item{strdataframe}{dataframe; a dataframe contained one column to split.}

\item{prefix}{character; the result dataframe columns names prefix, default is "tax".}

\item{sep}{character; the field separator character, default is "; ".}

\item{extra}{character; See \code{\link[tidyr]{separate}} details.}

\item{fill}{character; See \code{\link[tidyr]{separate}} details.}

\item{..., }{Additional arguments passed to \code{\link[tidyr]{separate}}.}
}
\value{
data.frame of strdataframe by sep.
}
\description{
split a dataframe contained one column with a specify field separator character.
}
\examples{
\dontrun{
    otudafile <- system.file("extdata", "otu_tax_table.txt",
                          package="MicrobiotaProcess")
    samplefile <- system.file("extdata",
                     "sample_info.txt", package="MicrobiotaProcess")
    otuda <- read.table(otudafile, sep="\t", header=TRUE,
                        row.names=1, check.names=FALSE,
                        skip=1, comment.char="")
    sampleda <- read.table(samplefile,
                sep="\t", header=TRUE, row.names=1)
    taxdf <- otuda[!sapply(otuda, is.numeric)]
    taxdf <- split_str_to_list(taxdf)
    head(taxdf)
}
}
\author{
Shuangbin Xu
}
