% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-show.R
\name{show,diffAnalysisClass-method}
\alias{show,diffAnalysisClass-method}
\alias{show,alphasample-method}
\alias{show,MPSE-method}
\title{method extensions to show for diffAnalysisClass or alphasample objects.}
\usage{
\S4method{show}{diffAnalysisClass}(object)

\S4method{show}{alphasample}(object)

\S4method{show}{MPSE}(object)
}
\arguments{
\item{object}{object, diffAnalysisClass or alphasample class}
}
\value{
print info
}
\description{
method extensions to show for diffAnalysisClass or alphasample objects.
}
\examples{
\dontrun{
data(kostic2012crc)
kostic2012crc \%<>\% as.phyloseq()
head(phyloseq::sample_data(kostic2012crc),3)
kostic2012crc <- phyloseq::rarefy_even_depth(kostic2012crc,rngseed=1024)
table(phyloseq::sample_data(kostic2012crc)$DIAGNOSIS)
set.seed(1024)
diffres <- diff_analysis(kostic2012crc, classgroup="DIAGNOSIS",
                        mlfun="lda", filtermod="fdr",
                        firstcomfun = "kruskal.test",
                        firstalpha=0.05, strictmod=TRUE, 
                        secondcomfun = "wilcox.test",
                        subclmin=3, subclwilc=TRUE,
                        secondalpha=0.01, lda=3)
show(diffres)
}
}
\author{
Shuangbin Xu
}
