% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_filter_taxa.R
\name{mp_filter_taxa}
\alias{mp_filter_taxa}
\alias{mp_filter_taxa,MPSE-method}
\alias{mp_filter_taxa,MPSE}
\alias{mp_filter_taxa,tbl_mpse-method}
\alias{mp_filter_taxa,tbl_mpse}
\alias{mp_filter_taxa,grouped_df_mpse-method}
\alias{mp_filter_taxa,grouped_df_mpse}
\title{Filter OTU (Features) By Abundance Level}
\usage{
mp_filter_taxa(
  .data,
  .abundance = NULL,
  min.abun = 0,
  min.prop = 0.05,
  include.lowest = FALSE,
  ...
)

\S4method{mp_filter_taxa}{MPSE}(
  .data,
  .abundance = NULL,
  min.abun = 0,
  min.prop = 0.05,
  include.lowest = FALSE,
  ...
)

\S4method{mp_filter_taxa}{tbl_mpse}(
  .data,
  .abundance = NULL,
  min.abun = 0,
  min.prop = 0.05,
  include.lowest = FALSE,
  ...
)

\S4method{mp_filter_taxa}{grouped_df_mpse}(
  .data,
  .abundance = NULL,
  min.abun = 0,
  min.prop = 0.05,
  include.lowest = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse or grouped_df_mpse object.}

\item{.abundance}{the column names of abundance, default is NULL, 
meaning the 'Abundance' column.}

\item{min.abun}{numeric minimum abundance required for each one sample
default is 0 (.abundance=Abundance or NULL), meaning the abundance of
OTU (Features) for each one sample should be >= 0.}

\item{min.prop}{numeric minimum proportion of samples that contains the OTU (Features)
when min.prop larger than 1, meaning the minimum number of samples that contains 
the OTU (Features).}

\item{include.lowest}{logical whether include the lower boundary of \code{min.abun}
default is FALSE ( > \code{min.abun}), if it is TRUE, meaning (>= \code{min.abun}).}

\item{...}{additional parameters, meaningless now.}
}
\description{
Filter OTU (Features) By Abundance Level
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\% mp_filter_taxa(.abundance=Abundance, min.abun=1, min.prop=1)
# For tbl_mpse object.
mouse.time.mpse \%>\% as_tibble \%>\% mp_filter_taxa(.abundance=Abundance, min.abun=1, min.prop=1)
# This also can be done using group_by, filter of dplyr.
mouse.time.mpse \%>\% 
 dplyr::group_by(OTU) \%>\% 
 dplyr::filter(sum(Abundance>=1)>=1)
}
\author{
Shuangbin Xu
}
