% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_decostand.R
\docType{methods}
\name{mp_decostand}
\alias{mp_decostand}
\alias{mp_decostand,data.frame-method}
\alias{mp_decostand,data.frame}
\alias{mp_decostand,MPSE-method}
\alias{mp_decostand,MPSE}
\alias{mp_decostand,tbl_mpse-method}
\alias{mp_decostand,tbl_mpse}
\alias{mp_decostand,grouped_df_mpse-method}
\alias{mp_decostand,grouped_df_mpse}
\title{This Function Provideds Several Standardization Methods for Community Data}
\source{
mp_decostand for data.frame object is a wrapper method of vegan::decostand from the vegan package
}
\usage{
mp_decostand(.data, .abundance = NULL, method = "hellinger", logbase = 2, ...)

\S4method{mp_decostand}{data.frame}(.data, .abundance = NULL, method = "hellinger", logbase = 2, ...)

\S4method{mp_decostand}{MPSE}(.data, .abundance = NULL, method = "hellinger", logbase = 2, ...)

\S4method{mp_decostand}{tbl_mpse}(.data, .abundance = NULL, method = "hellinger", logbase = 2, ...)

\S4method{mp_decostand}{grouped_df_mpse}(.data, .abundance = NULL, method = "hellinger", logbase = 2, ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the names of otu abundance to be applied standardization.}

\item{method}{character the name of standardization method, it can one of 
'total', 'max', 'frequency', 'normalize', 'range', 'rank', 'rrank', 'standardize'
'pa', 'chi.square', 'hellinger' and 'log', see also \code{\link[vegan]{decostand}}}

\item{logbase}{numeric The logarithm base used in 'method=log', default is 2.}

\item{...}{additional parameters, see also \code{\link[vegan]{decostand}}}
}
\value{
update object
}
\description{
This Function Provideds Several Standardization Methods for Community Data
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\% 
mp_decostand(.abundance=Abundance, method="hellinger")
}
\seealso{
[mp_extract_assays()] and [mp_rrarefy()]

\link[vegan]{decostand}
}
\author{
Shuangbin Xu
}
