% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_venn.R
\name{mp_cal_venn}
\alias{mp_cal_venn}
\alias{mp_cal_venn,MPSE-method}
\alias{mp_cal_venn,MPSE}
\alias{mp_cal_venn,tbl_mpse-method}
\alias{mp_cal_venn,tbl_mpse}
\alias{mp_cal_venn,grouped_df_mpse-method}
\alias{mp_cal_venn,grouped_df_mpse}
\title{Calculating the OTU for each sample or group, the result can be visualized by 'ggVennDiagram'}
\usage{
mp_cal_venn(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_venn}{MPSE}(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_venn}{tbl_mpse}(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_venn}{grouped_df_mpse}(
  .data,
  .group,
  .abundance = NULL,
  action = "add",
  force = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.group}{the name of group to be calculated.
if it is no provided, the sample will be used.}

\item{.abundance}{the name of otu abundance to be calculated.
if it is null, the rarefied abundance will be used.}

\item{action}{character, "add" joins the new information to the tibble of tbl_mpse or 
rowData of MPSE. "only" and "get" return a non-redundant tibble with the just new information.}

\item{force}{logical whether calculate the relative abundance forcibly when the abundance
is not be rarefied, default is FALSE.}

\item{...}{additional parameters.}
}
\value{
update object or tibble according the 'action'
}
\description{
Calculating the OTU for each sample or group, the result can be visualized by 'ggVennDiagram'
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\%
mp_rrarefy() \%>\%
mp_cal_venn(.abundance=RareAbundance, .group=time, action="add") -> mpse
mpse
p <- mpse \%>\% mp_plot_venn(.venn = vennOftime, .group = time)
\dontrun{
# visualized by manual
library(ggplot2)
mpse \%>\% 
  mp_extract_sample() \%>\% 
  select(time, vennOftime) \%>\%
  distinct() \%>\%
  pull(var=vennOftime, name=time) \%>\%
  ggVennDiagram::ggVennDiagram()
}
}
\seealso{
[mp_plot_venn()]
}
\author{
Shuangbin Xu
}
