% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_rda_cca.R
\name{mp_cal_rda}
\alias{mp_cal_rda}
\alias{mp_cal_rda,MPSE-method}
\alias{mp_cal_rda,MPSE}
\alias{mp_cal_rda,tbl_mpse-method}
\alias{mp_cal_rda,tbl_mpse}
\alias{mp_cal_rda,grouped_df_mpse-method}
\alias{mp_cal_rda,grouped_df_mpse}
\title{[Partial] [Constrained] Redundancy Analysis with MPSE or tbl_mpse object}
\usage{
mp_cal_rda(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)

\S4method{mp_cal_rda}{MPSE}(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)

\S4method{mp_cal_rda}{tbl_mpse}(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)

\S4method{mp_cal_rda}{grouped_df_mpse}(.data, .abundance, .formula = NULL, .dim = 3, action = "add", ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{.formula}{Model formula right hand side gives the constraining
variables, and conditioning variables can be given within a special
function 'Condition' and keep left empty, such as ~ A + B or ~ A + Condition(B),
default is NULL.}

\item{.dim}{integer The number of dimensions to be returned, default is 3.}

\item{action}{character "add" joins the rda result to the object, "only" return
a non-redundant tibble with the rda result. "get" return 'rda' object can
be analyzed using the related vegan funtion.}

\item{...}{additional parameters see also 'rda' of vegan.}
}
\value{
update object according action argument
}
\description{
[Partial] [Constrained] Redundancy Analysis with MPSE or tbl_mpse object
}
\examples{
library(vegan)
data(varespec, varechem)
mpse <- MPSE(assays=list(Abundance=t(varespec)), colData=varechem)
mpse
mpse \%>\% 
  mp_cal_rda(.abundance=Abundance, 
             .formula=~Al + P*(K + Baresoil),
             .dim = 3,
             action="add") \%>\%
  mp_plot_ord(show.sample=TRUE)
}
\author{
Shuangbin Xu
}
