% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pcoa.R
\name{mp_cal_pcoa}
\alias{mp_cal_pcoa}
\alias{mp_cal_pcoa,MPSE-method}
\alias{mp_cal_pcoa,MPSE}
\alias{mp_cal_pcoa,tbl_mpse-method}
\alias{mp_cal_pcoa,tbl_mpse}
\alias{mp_cal_pcoa,grouped_df_mpse-method}
\alias{mp_cal_pcoa,grouped_df_mpse}
\title{Principal Coordinate Analysis with MPSE or tbl_mpse object}
\usage{
mp_cal_pcoa(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 3,
  action = "add",
  ...
)

\S4method{mp_cal_pcoa}{MPSE}(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 3,
  action = "add",
  ...
)

\S4method{mp_cal_pcoa}{tbl_mpse}(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 3,
  action = "add",
  ...
)

\S4method{mp_cal_pcoa}{grouped_df_mpse}(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 3,
  action = "add",
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{distmethod}{character the method to calculate distance.}

\item{.dim}{integer The number of dimensions to be returned, default is 3.}

\item{action}{character "add" joins the pca result to the object and the 'pcoa'
object also was add to the internal attributes of the object, "only" return
a non-redundant tibble with the pca result. "get" return 'pcoa' object.}

\item{...}{additional parameters see also 'mp_cal_dist'.}
}
\value{
update object or tbl according to the action.
}
\description{
Principal Coordinate Analysis with MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
mpse <- mouse.time.mpse \%>\% 
        mp_decostand(.abundance=Abundance)
mpse
mpse \%<>\% mp_cal_pcoa(.abundance=hellinger, stmethod="bray", action="add")
library(ggplot2)
p <- mpse \%>\% mp_plot_ord(.ord=pcoa, .group=time, .color=time, ellipse=TRUE)
p <- p + 
     scale_fill_manual(values=c("#00AED7", "#009E73")) + 
     scale_color_manual(values=c("#00AED7", "#009E73"))  
\dontrun{
# Or run with action='only' and return tbl_df to visualize manual.
mouse.time.mpse \%>\% 
  mp_decostand(.abundance=Abundance) \%>\% 
  mp_cal_pcoa(.abundance=hellinger, distmethod="bray", .dim=2, action="only") -> tbl
tbl
x <- names(tbl)[grepl("PCo1 ", names(tbl))] \%>\% as.symbol()
y <- names(tbl)[grepl("PCo2 ", names(tbl))] \%>\% as.symbol()
library(ggplot2)
tbl \%>\% 
 ggplot(aes(x=!!x, y=!!y, color=time)) + 
 stat_ellipse(aes(fill=time), geom="polygon", alpha=0.5) +
 geom_point() +
 geom_vline(xintercept=0, color="grey20", linetype=2) + 
 geom_hline(yintercept=0, color="grey20", linetype=2) +
 theme_bw() +
 theme(panel.grid=element_blank())
}
}
\author{
Shuangbin Xu
}
