% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_alpha.R
\docType{methods}
\name{mp_cal_alpha}
\alias{mp_cal_alpha}
\alias{mp_cal_alpha,MPSE-method}
\alias{mp_cal_alpha,MPSE}
\alias{mp_cal_alpha,tbl_mpse-method}
\alias{mp_cal_alpha,tbl_mpse}
\alias{mp_cal_alpha,grouped_df_mpse-method}
\alias{mp_cal_alpha,grouped_df_mpse}
\title{calculate the alpha index with MPSE or tbl_mpse}
\usage{
mp_cal_alpha(
  .data,
  .abundance = NULL,
  action = c("add", "only", "get"),
  force = FALSE,
  ...
)

\S4method{mp_cal_alpha}{MPSE}(.data, .abundance = NULL, action = "add", force = FALSE, ...)

\S4method{mp_cal_alpha}{tbl_mpse}(.data, .abundance = NULL, action = "add", force = FALSE, ...)

\S4method{mp_cal_alpha}{grouped_df_mpse}(.data, .abundance = NULL, action = "add", force = FALSE, ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{The column name of OTU abundance column to be calculate}

\item{action}{character it has three options, "add" joins the new information 
to the input tbl (default), "only" return a non-redundant tibble with the just 
new information, ang 'get' return a 'alphasample' object.}

\item{force}{logical whether calculate the alpha index even the '.abundance' is 
not rarefied, default is FALSE.}

\item{...}{additional arguments}
}
\value{
update object or other (refer to action)
}
\description{
calculate the alpha index with MPSE or tbl_mpse
}
\examples{
data(mouse.time.mpse)
mpse <- mouse.time.mpse \%>\% 
        mp_rrarefy() \%>\%
        mp_cal_alpha(.abundance=RareAbundance)
mpse
p <- mpse \%>\% mp_plot_alpha(.group=time, .alpha=c(Observe, Shannon, Pielou))
p
# Or you can extract the result and visualize it with ggplot2 and ggplot2-extensions
\dontrun{
tbl <- mpse \%>\% 
       mp_extract_sample()
tbl
tbl \%<>\% 
  tidyr::pivot_longer(cols=!c("Sample", "time"), names_to="measure", values_to="alpha")
tbl
library(ggplot2)
library(ggsignif)
p <- ggplot(data=tbl, aes(x=time, y=alpha, fill=time)) + 
     geom_violin(color=NA, trim=FALSE) + 
     geom_boxplot(aes(color=time), fill=NA, width=0.2) + 
     geom_jitter(shape=21, width = .1) + 
     geom_signif(comparisons=list(c("Early", "Late")), test="wilcox.test", textsize=2) + 
     facet_wrap(facet=vars(measure), scales="free_y", nrow=1) +
     scale_fill_manual(values=c("#00A087FF", "#3C5488FF")) + 
     scale_color_manual(values=c("#00A087FF", "#3C5488FF"))
p
}
}
\seealso{
[mp_plot_alpha()]
}
\author{
Shuangbin Xu
}
