% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_aggregate_clade.R
\name{mp_aggregate_clade}
\alias{mp_aggregate_clade}
\alias{mp_aggregate_clade,MPSE-method}
\alias{mp_aggregate_clade,MPSE}
\alias{mp_aggregate_clade,tbl_mpse-method}
\alias{mp_aggregate_clade,tbl_mpse}
\alias{mp_aggregate_clade,grouped_df_mpse-method}
\alias{mp_aggregate_clade,grouped_df_mpse}
\title{calculate the mean/median (relative) abundance of internal nodes according to their children tips.}
\usage{
mp_aggregate_clade(
  .data,
  .abundance = NULL,
  force = FALSE,
  relative = TRUE,
  aggregate_fun = c("mean", "median", "geometric.mean"),
  action = "get",
  ...
)

\S4method{mp_aggregate_clade}{MPSE}(
  .data,
  .abundance = NULL,
  force = FALSE,
  relative = TRUE,
  aggregate_fun = c("mean", "median", "geometric.mean"),
  action = "get",
  ...
)

\S4method{mp_aggregate_clade}{tbl_mpse}(
  .data,
  .abundance = NULL,
  force = FALSE,
  relative = TRUE,
  aggregate_fun = c("mean", "median", "geometric.mean"),
  action = "get",
  ...
)

\S4method{mp_aggregate_clade}{grouped_df_mpse}(
  .data,
  .abundance = NULL,
  force = FALSE,
  relative = TRUE,
  aggregate_fun = c("mean", "median", "geometric.mean"),
  action = "get",
  ...
)
}
\arguments{
\item{.data}{MPSE object which must contain otutree slot, required}

\item{.abundance}{the column names of abundance.}

\item{force}{logical whether calculate the (relative) abundance forcibly when the abundance
is not be rarefied, default is FALSE.}

\item{relative}{logical whether calculate the relative abundance.}

\item{aggregate_fun}{function the method to calculate the (relative) abundance of internal nodes
according to their children tips, default is 'mean', other options are 'median', 'geometric.mean'.}

\item{action}{character, "add" joins the new information to the otutree slot if it exists (default). 
In addition, "only" return a non-redundant tibble with the just new information. "get" return a new 'mpse',
which the features is the internal nodes.}

\item{...}{additional parameters, meaningless now.}
}
\value{
a object according to 'action' argument.
}
\description{
calculate the mean/median (relative) abundance of internal nodes according to their children tips.
}
\examples{
\dontrun{
  suppressPackageStartupMessages(library(curatedMetagenomicData))
  xx <- curatedMetagenomicData('ZellerG_2014.relative_abundance', dryrun=F)
  xx[[1]] \%>\% as.mpse -> mpse
  otu.tree <- mpse \%>\% 
    mp_aggregate_clade(
      .abundance = Abundance, 
      force = TRUE, 
      relative = FALSE,
      action = 'get' # other option is 'add' or 'only'.
    )
  otu.tree
}
}
