% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_rarecurve.R
\name{get_rarecurve}
\alias{get_rarecurve}
\alias{get_rarecurve,data.frame-method}
\alias{get_rarecurve,data.frame}
\alias{get_rarecurve,phyloseq-method}
\alias{get_rarecurve,phyloseq}
\title{obtain the result of rare curve}
\usage{
get_rarecurve(obj, ...)

\S4method{get_rarecurve}{data.frame}(obj, sampleda, factorLevels = NULL, chunks = 400)

\S4method{get_rarecurve}{phyloseq}(obj, ...)
}
\arguments{
\item{obj}{phyloseq class or data.frame
shape of data.frame (nrow sample * ncol feature)}

\item{..., }{additional parameters.}

\item{sampleda}{data.frame, (nrow sample * ncol factor)}

\item{factorLevels}{list, the levels of the factors, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{chunks}{integer, the number of subsample in a sample, 
default is 400.}
}
\value{
rarecurve class, which can be visualized by ggrarecurve
}
\description{
generate the result of rare curve.
}
\details{
This function is designed to calculate the rare curve result of otu table
the result can be visualized by `ggrarecurve`.
}
\examples{
\dontrun{
    data(test_otu_data)
    test_otu_data \%<>\% as.phyloseq()
    set.seed(1024)
    res <- get_rarecurve(test_otu_data, chunks=200)
    p <- ggrarecurve(obj=res, 
                     indexNames=c("Observe","Chao1","ACE"),
                     shadow=FALSE,
                     factorNames="group")
}
}
\author{
Shuangbin Xu
}
