% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_alpha.R
\name{get_alphaindex}
\alias{get_alphaindex}
\alias{get_alphaindex,matrix-method}
\alias{get_alphaindex,matrix}
\alias{get_alphaindex,data.frame-method}
\alias{get_alphaindex,data.frame}
\alias{get_alphaindex,integer-method}
\alias{get_alphaindex,integer}
\alias{get_alphaindex,numeric-method}
\alias{get_alphaindex,numeric}
\alias{get_alphaindex,phyloseq-method}
\alias{get_alphaindex,phyloseq}
\title{alpha index}
\usage{
get_alphaindex(obj, ...)

\S4method{get_alphaindex}{matrix}(obj, mindepth, sampleda, force = FALSE, ...)

\S4method{get_alphaindex}{data.frame}(obj, ...)

\S4method{get_alphaindex}{integer}(obj, ...)

\S4method{get_alphaindex}{numeric}(obj, ...)

\S4method{get_alphaindex}{phyloseq}(obj, ...)
}
\arguments{
\item{obj}{object, data.frame of (nrow sample * ncol taxonomy(feature)) 
or phyloseq.}

\item{...}{additional arguments.}

\item{mindepth}{numeric, Subsample size for rarefying community.}

\item{sampleda}{data.frame,sample information, row sample * column factors.}

\item{force}{logical whether calculate the alpha index even the count of otu is
not rarefied, default is FALSE. If it is TRUE, meaning the rarefaction is not be
performed automatically.}
}
\value{
data.frame contained alpha Index.
}
\description{
calculate the alpha index (Obseve,Chao1,Shannon,Simpson) of sample
with \code{\link[vegan]{diversity}}
}
\examples{
\dontrun{
otudafile <- system.file("extdata", "otu_tax_table.txt", 
                        package="MicrobiotaProcess")
otuda <- read.table(otudafile, sep="\t", 
             header=TRUE, row.names=1, 
             check.names=FALSE, skip=1, comment.char="")
otuda <- otuda[sapply(otuda, is.numeric)] \%>\% t() \%>\% 
          data.frame(check.names=FALSE)
set.seed(1024)
alphatab <- get_alphaindex(otuda)
head(as.data.frame(alphatab))
data(test_otu_data)
class(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
class(test_otu_data)
set.seed(1024)
alphatab2 <- get_alphaindex(test_otu_data)
head(as.data.frame(alphatab2))
}
}
\author{
Shuangbin Xu
}
