% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{MethylMix_ModelSingleGene}
\alias{MethylMix_ModelSingleGene}
\title{The MethylMix_ModelSingleGene function}
\usage{
MethylMix_ModelSingleGene(GeneName, METdataVector, METdataNormalVector = NULL,
  NoNormalMode = FALSE, maxComp = 3, PvalueThreshold = 0.01,
  MeanDifferenceTreshold = 0.1, minSamplesPerGroup = 1)
}
\arguments{
\item{GeneName}{character string with the name of the gene to model}

\item{METdataVector}{vector with methylation data for cancer samples.}

\item{METdataNormalVector}{vector with methylation data for normal samples. It can be NULL and then no normal mode will be used.}

\item{NoNormalMode}{logical, if TRUE no comparison to normal samples is performed. Defaults to FALSE.}

\item{maxComp}{maximum number of mixture components admitted in the model (3 by default).}

\item{PvalueThreshold}{threshold to consider results significant.}

\item{MeanDifferenceTreshold}{threshold in beta value scale from which two methylation means are considered different.}

\item{minSamplesPerGroup}{minimum number of samples required to belong to a new mixture component in order to accept it. Defaul is 1 (not used). If -1, each component has to have at least 5\% of all cancer samples.}
}
\value{
NrComponents number of components identified.

Models an object with the parameters of the model fitted.

MethylationStates vector with DM values for each sample.

MixtureStates vector with DMvalues for each component.

Classifications a vector indicating to which component each sample was assigned.

FlipOverState FlipOverState
}
\description{
Internal. For a given gene, this function fits the mixture model, selects the number of components and defines the respective methylation states.
}
\details{
maxComp, PvalueThreshold, METDiffThreshold, minSamplesPerGroup are arguments for this function but are fixed in their default values for the user
because they are not available in the main MethylMix function, to keep it simple. It would be easy to make them available to the user if we want to.
}
\keyword{internal}
