% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{MethylMix}
\alias{MethylMix}
\title{MethylMix: Mixture model for DNA methylation data in cancer.}
\usage{
MethylMix(METcancer, GEcancer, METnormal = NULL, listOfGenes = NULL,
  filter = TRUE, NoNormalMode = FALSE, OutputRoot = "")
}
\arguments{
\item{METcancer}{Matrix with the methylation data of cancer tissue with genes in rows and samples in columns.}

\item{GEcancer}{Gene expression data for cancer tissue with genes in rows and samples in columns.}

\item{METnormal}{Matrix with the normal methylation data of the same genes as in METcancer. Again genes in rows and samples in columns. The samples do not have to match with the cancer data. If this argument is NULL, MethylMix will run without comparing to normal samples.}

\item{listOfGenes}{Vector with genes names to be evaluated, names must coincide with the names of the rows of METcancer.}

\item{filter}{Logical indicating if the linear regression to select genes with significative linear negative relation between methylation and gene expression should be performed (default: TRUE).}

\item{NoNormalMode}{Logical indicating if the methylation states found in the cancer samples should be compared to the normal samples (default: FALSE).}

\item{OutputRoot}{Path to store the MethylMix results object.}
}
\value{
MethylMixResults is a list with the following components:
\item{MethylationDrivers}{Genes identified as transcriptionally predictive and differentially methylated by MethylMix.}
\item{NrComponents}{The number of methylation states found for each driver gene.}
\item{MixtureStates}{A list with the DM-values for each driver gene. 
Differential Methylation values (DM-values) are defined as the difference between 
the methylation mean in one mixture component of cancer samples and the methylation mean
in the normal samples, for a given gene.}
\item{MethylationStates}{Matrix with DM-values for all driver genes (rows) and all samples (columns).}
\item{Classifications}{Matrix with integers indicating to which mixture component each cancer sample was assigned to, for each gene.}
\item{Models}{Beta mixture model parameters for each driver gene.}
}
\description{
MethylMix identifies DNA methylation driven genes by modeling DNA methylation data in cancer vs. normal and looking 
for homogeneous subpopulations. In addition matched gene expression data (e.g. from microarray technology or RNA sequencing) 
is used to identify functional DNA methylation events by requiring a negative correlation between methylation 
and gene expression of a particular gene. See references below.
}
\examples{
# load the three data sets needed for MethylMix
data(METcancer)
data(METnormal)
data(GEcancer)

# run MethylMix on a small set of example data
MethylMixResults <- MethylMix(METcancer, GEcancer, METnormal)

\dontrun{
# run in parallel
library(doParallel)
cl <- makeCluster(5)
registerDoParallel(cl)
MethylMixResults <- MethylMix(METcancer, GEcancer, METnormal)
stopCluster(cl)
}

}
\references{
Gevaert 0. \href{https://academic.oup.com/bioinformatics/article-lookup/doi/10.1093/bioinformatics/btv020}{MethylMix: an R package for identifying DNA methylation-driven genes}. Bioinformatics (Oxford, England). 2015;31(11):1839-41. doi:10.1093/bioinformatics/btv020.

Gevaert O, Tibshirani R, Plevritis SK. \href{http://genomebiology.biomedcentral.com/articles/10.1186/s13059-014-0579-8}{Pancancer analysis of DNA methylation-driven genes using MethylMix}. Genome Biology. 2015;16(1):17. doi:10.1186/s13059-014-0579-8.

Pierre-Louis Cedoz, Marcos Prunello, Kevin Brennan, Olivier Gevaert; MethylMix 2.0: an R package for identifying DNA methylation genes. Bioinformatics. doi:10.1093/bioinformatics/bty156.
}
