% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Download_Preprocess.R
\name{Download_DNAmethylation}
\alias{Download_DNAmethylation}
\title{The Download_DNAmethylation function}
\usage{
Download_DNAmethylation(CancerSite, TargetDirectory, downloadData = TRUE)
}
\arguments{
\item{CancerSite}{character of length 1 with TCGA cancer code.}

\item{TargetDirectory}{character with directory where a folder for downloaded files will be created.}

\item{downloadData}{logical indicating if data should be downloaded (default: TRUE). If false, the url of the desired data is returned.}
}
\value{
list with paths to downloaded files for both 27k and 450k methylation data.
}
\description{
Downloads DNA methylation data from TCGA.
}
\examples{
\dontrun{

# Optional register cluster to run in parallel
library(doParallel)
cl <- makeCluster(5)
registerDoParallel(cl)

# Methylation data for ovarian cancer
cancerSite <- "OV"
targetDirectory <- paste0(getwd(), "/")

# Downloading methylation data
METdirectories <- Download_DNAmethylation(cancerSite, targetDirectory, TRUE)

# Processing methylation data
METProcessedData <- Preprocess_DNAmethylation(cancerSite, METdirectories)

# Saving methylation processed data
saveRDS(METProcessedData, file = paste0(targetDirectory, "MET_", cancerSite, "_Processed.rds"))

# Clustering methylation data
res <- ClusterProbes(METProcessedData[[1]], METProcessedData[[2]])

# Saving methylation clustered data
toSave <- list(METcancer = res[[1]], METnormal = res[[2]], ProbeMapping = res$ProbeMapping)
saveRDS(toSave, file = paste0(targetDirectory, "MET_", cancerSite, "_Clustered.rds"))

stopCluster(cl)
}
 
}
\keyword{download}
