% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_exp_se}
\alias{make_exp_se}
\title{Transform gene expression matrix into a Summarized Experiment object}
\usage{
make_exp_se(exp, genome = c("hg38", "hg19"), verbose = FALSE)
}
\arguments{
\item{exp}{Gene expression matrix with gene expression counts,
row as ENSG gene IDS and column as samples}

\item{genome}{Human genome of reference: hg38 or hg19}

\item{verbose}{A logical argument indicating if
messages output should be provided.}
}
\value{
A summarized Experiment object
}
\description{
Transform gene expression matrix into a Summarized Experiment object
}
\examples{
gene.exp.chr21.log2 <- get(data("gene.exp.chr21.log2"))
gene.exp.chr21.log2.se <- make_exp_se(gene.exp.chr21.log2)
}
