% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tf_in_region.R
\name{get_tf_in_region}
\alias{get_tf_in_region}
\title{Get human TFs for regions by either scanning it with motifmatchr using
JASPAR 2024 database or overlapping with TF chip-seq from user input}
\usage{
get_tf_in_region(
  region,
  window.size = 0,
  genome = c("hg19", "hg38"),
  p.cutoff = 1e-08,
  cores = 1,
  TF.peaks.gr = NULL,
  verbose = FALSE
)
}
\arguments{
\item{region}{A vector of region names or GRanges object with the DNA
methylation regions to be scanned for the motifs}

\item{window.size}{Integer value to extend the regions.
For example, a value of 50 will
extend 25 bp upstream and 25 bp downstream the region.
The default is not to increase the scanned region.}

\item{genome}{Human genome of reference "hg38" or "hg19".}

\item{p.cutoff}{motifmatchr p.cutoff. Default 1e-8.}

\item{cores}{Number of CPU cores to be used. Default 1.}

\item{TF.peaks.gr}{A granges with TF peaks to be overlaped with input region
Metadata column expected "id" with TF name. Default NULL. Note that Remap catalog
can be used as shown in the examples.}

\item{verbose}{A logical argument indicating if
messages output should be provided.}
}
\value{
A data frame with the following information: regionID, TF symbol, TF ensembl ID
}
\description{
Given a genomic region, this function maps TF in regions
using two methods: 1) using motifmatchr nd JASPAR 2024 to scan the
region for 554 human transcription factors
binding sites. There is also  an option (argument \code{window.size})
to extend the scanning region before performing the search, which
by default is 0 (do not extend).
2) Using user input  TF chip-seq to check for overlaps between region
and TF peaks.
}
\examples{
 regions.names <- c("chr3:189631389-189632889","chr4:43162098-43163498")
 region.tf <- get_tf_in_region(
                 region = regions.names,
                 genome = "hg38"
 )

\dontrun{
   library(ReMapEnrich)
   demo.dir <- "~/ReMapEnrich_demo"
   dir.create(demo.dir, showWarnings = FALSE, recursive = TRUE)
   # Use the function DowloadRemapCatalog
   remapCatalog2018hg38 <- downloadRemapCatalog(demo.dir, assembly = "hg38")
   # Load the ReMap catalogue and convert it to Genomic Ranges
   remapCatalog <- bedToGranges(remapCatalog2018hg38)
   regions.names <- c("chr3:189631389-189632889","chr4:43162098-43163498")
   region.tf.remap <- get_tf_in_region(
                   region = regions.names,
                   genome = "hg38",
                   TF.peaks.gr = remapCatalog
   )
 }
}
