% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_quantile.R
\name{filter_exp_by_quant_mean_FC}
\alias{filter_exp_by_quant_mean_FC}
\title{Select genes with variations above a threshold}
\usage{
filter_exp_by_quant_mean_FC(exp, fold.change = 1.5, cores = 1)
}
\arguments{
\item{exp}{Gene expression matrix or SumarizedExperiment object}

\item{fold.change}{Threshold for fold change of mean gene
expression levels in samples with high
(Q4) and low (Q1) gene expression levels. Defaults to 1.5.}

\item{cores}{Number of CPU cores to be used in the analysis. Default: 1}
}
\value{
A subset of the original matrix only with the rows passing
the filter threshold.
}
\description{
For each gene, compares the mean gene expression
levels in samples in high expression (Q4)
vs. samples with low gene expression (Q1),
and requires the fold change to be above a certain threshold.
}
\examples{
data("gene.exp.chr21.log2")
gene.exp.chr21.log2.filtered <- filter_exp_by_quant_mean_FC(
  gene.exp.chr21.log2
)
}
